// pages/home/sign/index.js

const req = require('../../../api/teacher.js')
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    selectTags: {},
    classId: "",
    className: ""
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    let classId = options.classId
     this.setData({
       className: app.globalData.login.classes[0].departname
     })
    this.getAllStudent(classId)
  },

  getAllStudent: function(classId) {
    this.data.selectTags = {}
    req.getAllStudent(classId).then(res => {
      console.log(res)
      for (var i = 0; i < res.length; i++) {
        var record = res[i]
        let paymentType = app.globalData.studentPaymentTypes[record.studentPaymentType]
        record.name = record.name + ' (' + paymentType + ')'
        //存在签到id,说明已经签到过,自动打勾
        if (record.signSummaryId) {
          this.data.selectTags[i] = true
        }
      }

      this.setData({
        records: res,
        selectTags: this.data.selectTags,
        classId: classId
      })
    })
  },
  tapBox: function(e) {
    console.log(e)
    let selected = !e.currentTarget.dataset.check
    let tags = this.data.selectTags

    tags[e.currentTarget.dataset.cellindex] = selected
    this.setData({
      selectTags: tags
    })

  },
  operateTap: function(event) {
    console.log(event._relatedInfo.anchorTargetText)
    let records = this.data.records
    let that = this
    var studentIds = []
    for (var i = 0; i < records.length; i++) {
      let item = records[i]

      let student = {
        "studentId": item.id,
        "signSummaryId": item.signSummaryId,
        "signState": this.data.selectTags[i] ? 0 : 1//签到状态：0:签到 1：取消签到
      }

      if (student.signState == 0 && student.signSummaryId != null) {
        continue
      }

      studentIds.push(student)

    }

    if (studentIds.length == 0) {
      wx.showToast({
        title: '未做操作，请检查',
        icon:'none'
      })
      return;
    }

    req.signIn(app.globalData.login.user.id, this.data.classId, studentIds).then(res => {
      wx.showToast({
        title: '签到成功~',
        duration: 1500
      })
      setTimeout(() => {
        wx.navigateBack({
          delta: 1
        })
      }, 1500)
    }).catch(function (err) {
      that.getAllStudent(that.data.classId)
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      });
    });
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})