/**
 * 工具类
 */

const request = require('../api/request.js')

/**
 * 是否隐藏loading
 */
var _hide_loading;

const formatTime = date => {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()
  const hour = date.getHours()
  const minute = date.getMinutes()
  const second = date.getSeconds()

  return [year, month, day].map(formatNumber).join('/') + ' ' + [hour, minute, second].map(formatNumber).join(':')
}

const formatDate = date => {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()

  return [year, month, day].map(formatNumber).join('-')
}

const formatNumber = n => {
  n = n.toString()
  return n[1] ? n : '0' + n
}

// 计算两个经纬度之间的距离
const distance = (la1, lo1, la2, lo2) => {
  var La1 = la1 * Math.PI / 180.0;
  var La2 = la2 * Math.PI / 180.0;
  var La3 = La1 - La2;
  var Lb3 = lo1 * Math.PI / 180.0 - lo2 * Math.PI / 180.0;
  var s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(La3 / 2), 2) + Math.cos(La1) * Math.cos(La2) * Math.pow(Math.sin(Lb3 / 2), 2)));
  s = s * 6378.137; //地球半径
  s = Math.round(s * 10000) / 10000;
  // console.log("计算结果",s)
  return s
}

//小于10的格式化函数
function timeFormat(param) {
  return param < 10 ? '0' + param : param;
}

//倒计时函数
function countDown(teamBuyTimeList) {
  // 获取当前时间，同时得到活动结束时间数组
  const that = this
  let newTime = new Date().getTime() / 1000;
  let teamBuyTimeInfoList = teamBuyTimeList;
  let countDownArr = [];
  // 对结束时间进行处理渲染到页面
  teamBuyTimeInfoList.forEach(o => {
    // iOS不兼容？
    // let endTime = new Date(o).getTime();   
    // ios 转换时间戳？？？
    let date = o.openTeamTime.substr(0, 10) //2017-02-27
    let hour = o.openTeamTime.substr(11, 2) == '00' ? 0 : o.openTeamTime.substr(11, 2).replace(/\b(0+)/gi, "")
    let minute = o.openTeamTime.substr(14, 2) == '00' ? 0 : o.openTeamTime.substr(14, 2).replace(/\b(0+)/gi, "")
    let second = o.openTeamTime.substr(17, 2) == '00' ? 0 : o.openTeamTime.substr(17, 2).replace(/\b(0+)/gi, "")
    let timestamp = parseInt(new Date(date).getTime() / 1000) + parseInt(o.duration) + parseInt(hour) * 3600 + parseInt(minute) * 60 + parseInt(second) - 28800 //别问我为什么-28800，只能告诉你实践出真知                   
    //var endNewTime = timestampFormat(timestamp)//timestampFormat：自定义的将时间戳转换为刚刚，昨天16:42等表达的方法
    let endTime = timestamp
    let obj = null;
    // 如果活动未结束，对时间进行处理
    if (endTime - newTime > 0) {
      let time = (endTime - newTime);
      // 获取天、时、分、秒
      let day = parseInt(time / (60 * 60 * 24));
      let hou = parseInt(time % (60 * 60 * 24) / 3600) + parseInt(day * 24);
      let min = parseInt(time % (60 * 60 * 24) % 3600 / 60);
      let sec = parseInt(time % (60 * 60 * 24) % 3600 % 60);
      obj = {
        //day: this.timeFormat(day),
        hou: timeFormat(hou),
        min: timeFormat(min),
        sec: timeFormat(sec)
      }
    } else { //活动已结束，全部设置为'00'
      obj = {
        //day: '00',
        hou: '00',
        min: '00',
        sec: '00'
      }
    }
    countDownArr.push(obj)
  })
  // 渲染，然后每隔一秒执行一次倒计时函数
  return countDownArr
}

// 处理 Access Token 已过期
function handleLoginStatus(error) {
  if (error.code !== 20) {
    wx.showToast({
      title: error.msg,
      icon: 'none',
      duration: 2000
    })
  }
}

const timestampToTime = timestamp => {
  var date = new Date(timestamp); //时间戳为10位需*1000，时间戳为13位的话不需乘1000
  var Y = date.getFullYear() + '-';
  var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-';
  var D = formatNumber(date.getDate()) + ' ';
  var h = formatNumber(date.getHours()) + ':';
  var m = formatNumber(date.getMinutes()) + ':';
  var s = formatNumber(date.getSeconds());
  return Y + M + D + h + m + s;
}
/**
 * base64解码
 * 配合decodeURIComponent使用
 */
function base64_decode(input) {
  var base64EncodeChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
  var output = "";
  var chr1, chr2, chr3;
  var enc1, enc2, enc3, enc4;
  var i = 0;
  input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
  while (i < input.length) {
    enc1 = base64EncodeChars.indexOf(input.charAt(i++));
    enc2 = base64EncodeChars.indexOf(input.charAt(i++));
    enc3 = base64EncodeChars.indexOf(input.charAt(i++));
    enc4 = base64EncodeChars.indexOf(input.charAt(i++));
    chr1 = (enc1 << 2) | (enc2 >> 4);
    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
    chr3 = ((enc3 & 3) << 6) | enc4;
    output = output + String.fromCharCode(chr1);
    if (enc3 != 64) {
      output = output + String.fromCharCode(chr2);
    }
    if (enc4 != 64) {
      output = output + String.fromCharCode(chr3);
    }
  }
  return utf8_decode(output);
}


function utf8_decode(utftext) { // utf-8解码
  var string = '';
  let i = 0;
  let c = 0;
  let c1 = 0;
  let c2 = 0;
  while (i < utftext.length) {
    c = utftext.charCodeAt(i);
    if (c < 128) {
      string += String.fromCharCode(c);
      i++;
    } else if ((c > 191) && (c < 224)) {
      c1 = utftext.charCodeAt(i + 1);
      string += String.fromCharCode(((c & 31) << 6) | (c1 & 63));
      i += 2;
    } else {
      c1 = utftext.charCodeAt(i + 1);
      c2 = utftext.charCodeAt(i + 2);
      string += String.fromCharCode(((c & 15) << 12) | ((c1 & 63) << 6) | (c2 & 63));
      i += 3;
    }
  }
  return string;
}

const getAccessToken = () => {
  return wx.getStorageSync('__access_tokens__').accessToken
}

const uploadPath = () => {
  return `${request.DOMAIN}/wxsite/file/upload.do`
}

module.exports = {
  /**
   * 设置loading显示隐藏标识
   */
  setHideLoading: function (val) {
    if (val) {
      _hide_loading = true;
    } else {
      _hide_loading = false;
    }
    return _hide_loading;
  },

  /**
   * 隐藏下一次远程请求的loading
   */
  isHideLoading: function () {
    var b = _hide_loading;
    _hide_loading = false;
    return b
  },

  /**
   * 格式化日期 
   */
  formatTime: formatTime,

  /**
   * 计算两个经纬度之间的距离
   */
  distance: distance,

  /**
   * 小于10的格式化函数
   */
  timeFormat: timeFormat,

  /**
   * 倒计时函数
   * @param openTeamTime 开始时间
   * @param duration //持续时间
   */
  countDown: countDown,

  /**
   * 处理 Access Token 已过期
   */
  handleLoginStatus: handleLoginStatus,

  /**
   * 获取Access Token
   */
  getAccessToken: getAccessToken,

  /**
   * 
   */
  formatDate: formatDate,

  /**
   * 处理后台上传的图片在前端的显示
   */
  handleImgShow(imgId) {
    return `${request.DOMAIN}/commonController.do?viewFile&fileid=${imgId}`
  },

  /**
   * 时间戳转换时间
   */
  timestampToTime: timestampToTime,

  /**
   * 获取图片上传路径
   */
  uploadPath: uploadPath,
  /**
   * base64解码
   */
  base64_decode: base64_decode
}
