'use strict';
var utils = require('../utils/util.js');
var auth = require('../utils/auth.js');

// 网络异常代码
const ERR_NET_ERROR = -99999;
const ERR_ACCESS_TOKEN_EXPIRED = 20;
const ERR_NOT_ACCESS_TOKEN = 21;

// 取开发环境系统配置
var DEF_APP_CONFIG = {
  appId: "wxe19b38d5dbc061c6", // 勾芒小程序测试号
  // 开发环境
  // domain: 'https://dev.gomoretech.com/preschool',
  // baseUrl: "https://dev.gomoretech.com/preschool"
  // 川哥本地环境
  // domain: 'http://192.168.199.230:8080/preschool',
  // baseUrl: "http://192.168.199.230:8080/preschool",
  // 正式环境
  domain: 'https://preschool.gomoretech.com/preschool',
  baseUrl: "https://preschool.gomoretech.com/preschool"
}
const extConfig = wx.getExtConfigSync ? wx.getExtConfigSync() : DEF_APP_CONFIG;
const APP_ID = extConfig.appId || DEF_APP_CONFIG.appId;
const BASE_URL = extConfig.baseUrl || DEF_APP_CONFIG.baseUrl;

const APP_VERSION = 'wxapp-1.4.45'; // 当前小程序版本
const API_VERSION = '0.0.4'; // 当前API版本
const DOMAIN = DEF_APP_CONFIG.domain // 当前域名
const WXA_APPID = DEF_APP_CONFIG.appId; // 当前小程序的appid
var OS_VERSION = ''; // 当前微信操作系统版本
wx.getSystemInfo({
  success: function (res) {
    OS_VERSION = 'wxapp-' + res.version;
  }
})

/**
 * APP配置
 */
module.exports.APP_ID = APP_ID;
module.exports.DOMAIN = DOMAIN;
module.exports.BASE_URL = BASE_URL;

/**
 * 执行http请求
 */
module.exports.request = function (url, method = 'GET', data = {},
  contentType = 'json', dataType = 'json') {
  const self = this
  var headers = {};
  if (contentType == 'json') {
    headers['content-type'] = 'application/json';
  } else {
    headers['content-type'] = 'application/x-www-form-urlencoded';
  }

  try {
    var value = wx.getStorageSync('wj_wxa_formId')
    if (value) {
      headers['wxa-form-id'] = value;
      wx.removeStorageSync('wj_wxa_formId')
    }
  } catch (e) {
    console.log(e)
  }

  headers['app-version'] = APP_VERSION;
  headers['os-version'] = OS_VERSION;
  headers['api-version'] = API_VERSION;
  headers['wxa-appid'] = WXA_APPID;

  // 添加access token，暂不支持刷新access token
  var tokens = auth.getTokens();
  if (tokens && tokens.accessToken) {
    headers['access-token'] = tokens.accessToken
  }

  function onSucc(res, resolve, reject) {
    var ok = (res.statusCode >= 200 && res.statusCode < 300);
    if (!ok) {
      reject({
        code: ERR_NET_ERROR,
        msg: '网络错误'
      });
      return;
    }

    var userData = res.data;
    if (userData.code == 0) {
      // 如果成功，直接返回
      if (userData.obj == null) {
        wx.hideLoading()
        wx.showToast({
          title: userData.msg,
          icon: 'none',
          duration: 2000
        })
      }
      resolve(userData.obj);
    } else {
      if (userData.code != ERR_ACCESS_TOKEN_EXPIRED) {
        if (userData.code != ERR_NOT_ACCESS_TOKEN) {
          // 直接失败
          reject(userData);
        } else {
          userData = {
            ...userData,
            msg: '您还没有登录哦~'
          }
          reject(userData);
        }
      } else {
        // 特别处理Access Token已过期的异常： 重新登录后重放请求
        const postData = data;
        self.kg_login().then(data => {
          self.request(url, method, postData, contentType, dataType)
            .then(function (data) {
              resolve(data);
            }).catch(function (err) {
              reject(err);
            });
        }).catch(err => {
          if (err.code === '23001') {
            reject({
              msg: "信息已过期，请刷新当前页面"
            })
          } else {
            reject(err);
          }
        })
      }
    }
  }

  return new Promise(function (resolve, reject) {
    if (!utils.isHideLoading()) {
      wx.showLoading({
        title: '加载中...',
        mask: true
      });
    }

    wx.request({
      url: BASE_URL + url,
      method: method,
      dataType: dataType,
      data: data,
      header: headers,

      success: function (res) {
        onSucc(res, resolve, reject);
      },

      fail: function (res) {
        console.error(BASE_URL + url + ' 请求失败返回: ', res);
        var msg = res.errMsg;
        if (msg.indexOf("request:fail") >= 0) {
          msg = "网络错误";
        }
        reject({
          code: -1,
          msg: msg
        });
      },

      complete: function () {
        wx.hideLoading();
      }
    });
  });

}

/**
 * 小程序内部用户登录
 * 
 * @return code
 */
function wx_login() {
  return new Promise(function (resolve, reject) {
    wx.login({
      success: function (res) {
        console.debug('!!!微信登录返回结果-----' + JSON.stringify(res));
        if (res.code) {
          resolve(res.code);
        } else {
          reject({
            code: -1,
            msg: res.errMsg
          });
        }
      },
      fail: function (res) {
        reject({
          code: -1,
          msg: res.errMsg
        });
      }
    });
  });
}

/**
 * 小程序内部取得用户信息
 * 
 * @return 用户信息
 */
function wx_getUserInfo() {
  return new Promise(function (resolve, reject) {
    wx.getUserInfo({
      success: function (res) {
        console.log(res)
        resolve(res);
      },
      fail: function (res) {
        if (res.errMsg === 'getUserInfo:fail scope unauthorized') {
          wx.clearStorage();
          wx.startPullDownRefresh({
            success: function () {
              wx.stopPullDownRefresh();
            }
          })
          return;
        }
        reject({
          code: -1,
          msg: res.errMsg
        });
      }
    })
  });
}

/**
 * 用户登录
 * 
 * @param decryptUserInfo 是否解密用户信息
 * @return 用户信息，如果返回的 #member字段为空，说明当前粉丝没有绑定手机号， 还不是会员。
 */
module.exports.kg_login = function (decryptUserInfo = true, mobile, psw) {
  var self = this;
  var loginCode = '';
  return wx_login()
    .then(function (code) {
      loginCode = code;
      return wx_getUserInfo()
    })
    .then(function (res) {
      var encryptedUserInfo = null;
      decryptUserInfo && (encryptedUserInfo = {
        encryptedData: res.encryptedData,
        iv: res.iv
      });
      var req = {
        appid: APP_ID,
        code: loginCode,
        mobile: mobile,
        password:psw,
        encryptedUserInfo: encryptedUserInfo
      };
      return self.post('/wxsite/wxa/user/login.do', req);
    })
    .then(function (data) {
      // 保存登录结果
      auth.setTokens(data);
      return data;
    });
}

/**
 * HTTP GET
 */
module.exports.get = function (url, data) {
  return this.request(url, 'GET', data);
}

/**
 * HTTP POST
 */
module.exports.post = function (url, data) {
  return this.request(url, 'POST', data);
}

/**
 * HTTP PUT
 */
module.exports.put = function (url, data) {
  return this.request(url, 'PUT', data);
}

/**
 * HTTP DELETE
 */
module.exports.delete = function (url, data) {
  return this.request(url, 'DELETE', data);
}

/**
 * dev config
 */
module.exports.config = function () {
  return DEF_APP_CONFIG
}

module.exports.upload = function(options) {
  var url = options.url,
    path = options.path,
    name = options.name,
    // data = options.data,
    extra = options.extra,
    success = options.success,
    progress = options.progress,
    fail = options.fail

  console.log("upload url:" + url)
  const uploadTask = wx.uploadFile({
    url: url,
    filePath: path,
    name: name,
    formData: extra,
    success: function (res) {
      console.log(res);

      var data = res.data
      try {
        data = JSON.parse(res.data)
        console.log(data)
      }
      catch (e) {
        console.log(data)
        throw (e)
      }

      // data.code == 1000需要去掉，这里是根据自己的返回数据做相应判断
      if (res.statusCode == 200) {
        if (success) {
          success(data)
        }
      }
      else {
        if (fail) {
          fail(data)
        }
      }

    },
    fail: function (res) {
      console.log(res)
      if (fail) {
        fail(res)
      }
    }
  })

  uploadTask.onProgressUpdate((res) => {
    console.log('上传进度', res.progress)
    console.log('已经上传的数据长度', res.totalBytesSent)
    console.log('预期需要上传的数据总长度', res.totalBytesExpectedToSend)
    if (progress) (
      progress(res)
    )
  })
}