// pages/home/parents/index.js

const request = require('../../../api/parrent.js')
const utils = require('../../../utils/util.js')

const app = getApp()


Page({

  /**
   * 页面的初始数据
   */
  data: {
    page: 0,
    pageSize: 15,
    records: [],
    recordTypes: app.globalData.recordTypes,
    eatStates: app.globalData.eatStates,
    rightIcon: '/src/img/xiugaimima.png',
    pictureId: "",
    userIcon: "/src/img/defaut_teacher_icon.png",
    selectPic: [],
    student: {},
    //顶部加载提示信息
    hideTopMore: true,
    // 底部加载提示信息
    hideBottomMore: true,
    selectedIndex: 0,
    current: {
      // poster: ' ',
      name: ' ',
      author: '比来童园',
      src: ' ',
    },
    scheduleImage: '',
    recipeImage: '',
    innerAudioContext: {},
    isPlaying: false,
    btnImage: '/src/img/play.png',
    isRecipeNull: false,
    attachment: null,
    musicUrl: null
  },

  scrollToUpper: function(e) {
    console.log("滚动到顶部")
    this.setData({
      hideTopMore: false
    })

    this.data.page = 0
    this.httpRequest()
    this.getSchedule()
    this.getRecipe()

  },

  scrollToLower: function(e) {
    this.data.page++
      this.httpRequest()
  },

  tapTabItem: function(e) {
    console.log(e.currentTarget.dataset.index)
    this.setData({
      selectedIndex: e.currentTarget.dataset.index
    })
  },


  getRecipe: function(e) {
    
    request.getRecipe().then(res => {

      var url = utils.handleImgShow(res)
      console.log(url)
      this.setData({
        recipeImage: url,
        isRecipeNull: res == null
      })

    }).catch(function(err) {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      });
    });

  },

  getSchedule: function(e) {
    const that = this
    if (app.globalData.login.students.length == 0) {
      wx.showToast({
        title: '无学生信息, 请联系管理员',
        icon: 'none'
      })
      return
    }
    let student = app.globalData.login.students[0]
    var classId = student.classId

    request.getSchedule(classId).then(res => {
      console.log("ddd")
      let b = res.attachment == null
      console.log(b)

      this.setData({
        attachment: res.attachment,
        musicUrl: res.musicUrl
      })

      var url = utils.handleImgShow(res.attachment)
      console.log(url)

      const innerAudioContext = wx.createInnerAudioContext()
      this.data.innerAudioContext = innerAudioContext
      innerAudioContext.src = res.musicUrl
      innerAudioContext.loop = true
      innerAudioContext.onPlay(() => {

      })
      innerAudioContext.onPause(() => {

      })
      innerAudioContext.onError((res) => {
        console.log(res.errMsg)
        console.log(res.errCode)
      })
      innerAudioContext.onEnded((res) => {

      })

      this.setData({
        scheduleImage: url,
        current: {
          name: res.musicName,
        }
      })

    }).catch(function(err) {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      });
    });

  },

  tapPlayButton: function () {
    this.data.isPlaying = !this.data.isPlaying
    let btnImage = '/src/img/play.png'
    if (this.data.isPlaying) {
      this.data.innerAudioContext.play()
      btnImage = '/src/img/stop.png'
      wx.showToast({
        title: '开始播放',
        icon: 'none'
      })
    } else {
      this.data.innerAudioContext.pause()
      wx.showToast({
        title: '已暂停',
        icon: 'none'
      })
    }

    this.setData({
      btnImage: btnImage
    })
  },

  tapRecipe: function(e) {
    wx.previewImage({
      urls: [this.data.recipeImage],
    })

  },

  tapSchedule: function(e) {
    wx.previewImage({
      urls: [this.data.scheduleImage],
    })
  },

  tapUserInfoImg: function(e) {
    var that = this;
    // 选择图片
    wx.chooseImage({
      count: 1,
      sizeType: ['compressed'], // 可以指定是原图还是压缩图，默认二者都有
      sourceType: ['album', 'camera'], // 可以指定来源是相册还是相机，默认二者都有
      success: function(res) {
        //选中的图片路径
        let temPath = res.tempFilePaths[0]
        that.data.selectPic.push(temPath)
        that.setData({
          selectPic: that.data.selectPic
        });

        wx.uploadFile({
          url: utils.uploadPath(),
          filePath: temPath,
          name: 'file',
          header: {
            'access-token': utils.getAccessToken()
          },
          success(res) {
            const resData = JSON.parse(res.data)
            // 获取服务端图片id
            that.data.pictureId = resData.obj
            that.data.userIcon = utils.handleImgShow(resData.obj)
            if (resData.obj) {
              that.setData({
                pictureId: that.data.pictureId,
                userIcon: that.data.userIcon
              })

              that.updateStudentPicture()
            } else {
              throw new Error({
                msg: '图片上传失败'
              })
            }
          },
          fail(err) {
            wx.showToast({
              title: err.msg,
              icon: 'none'
            })
          }
        })

      }
    })
  },
  /* 跳转食谱 */
  operateRecipe: function() {
    wx.navigateTo({
      url: '/pages/home/recipe/recipe',
    })

  },
  /* 跳转课表 */
  operateSchedule: function() {
    wx.navigateTo({
      url: '/pages/home/schedule/schedule',
    })
  },

  updateStudentPicture: function() {
    request.updateStudentPicture(this.data.student.id, this.data.pictureId).then(res => {
      wx.showToast({
        title: "上传成功"
      });

    }).catch(function(err) {
      that.getAllStudent(that.data.classId)
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      });
    });
  },

  changePwdTap: function(e) {
    wx.navigateTo({
      url: '/pages/reset_psw/index',
    })
  },

  previewPic: function(e) {
    var current = this.data.records[e.target.dataset.index].arrPic[e.target.dataset.picindex]
    wx.previewImage({
      current: current,
      urls: this.data.records[e.target.dataset.index].arrPic
    })

  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    this.fillStudent()
    this.httpRequest()
    this.getSchedule()
    this.getRecipe()

  },

  fillStudent: function() {
    const that = this
    if (app.globalData.login.students.length == 0) {
      wx.showToast({
        title: '无学生信息, 请联系管理员',
        icon: 'none'
      })
      return
    }
    let student = app.globalData.login.students[0]
    var studentId = student.id
    this.setData({
      student: student,
      sex: student.sex
    })

    if (student.picture != null) {
      let pic = utils.handleImgShow(student.picture)
      this.setData({
        userIcon: pic
      })
    }

  },

  httpRequest: function() {
    const that = this
    request.queryStudentRecord(that.data.page, that.data.pageSize, that.data.student.id).then(res => {
      console.log(res)
      let resData = res

      var record = resData['records']
      var templist = this.data.records
      if (that.data.page == 0) {
        templist = []
        this.setData({
          hideTopMore: true
        })
      }
      for (var i = 0; i < record.length; i++) {
        var item = record[i]

        var dateStr = item.recordDate.substr(0, 10)
        let show_day = new Array('周日', '周一', '周二', '周三', '周四', '周五', '周六');
        let date = new Date(dateStr);
        var num = date.getDay()
        item.recordDate = dateStr + " " + show_day[date.getDay()]
        //图片
        var arrPic = []
        let arrIds = []
        if (item.pictures != null && item.pictures != '') {
          arrIds = item.pictures.split(",")
          for (var j = 0; j < arrIds.length; j++) {

            let id = arrIds[j]
            arrPic.push(utils.handleImgShow(id))
          }
        }
        console.log(arrPic)
        item.arrIds = arrIds
        item.arrPic = arrPic

        // 饮食
        var dietRecords = item['dietRecord']

        for (var j = 0; j < dietRecords.length; j++) {
          var diet = dietRecords[j]
          diet.z_recordType = that.data.recordTypes[diet.recordType]
          diet.z_eatState = that.data.eatStates[diet.eatState]
          if (diet.recordType == 'diet_milk') {
            diet.z_eatState = diet.value + "毫升"
          }
          if (diet.recordType == 'diet_water') {
            diet.z_eatState = diet.value + "次"
          }
        }

        // 睡觉
        var sleepRecord = item["sleepRecord"]
        for (var j = 0; j < sleepRecord.length; j++) {
          var r = sleepRecord[j]
          r.z_recordType = that.data.recordTypes[r.recordType]

        }

        // wc
        var wcRecord = item["wcRecord"]
        for (var j = 0; j < wcRecord.length; j++) {
          var r = wcRecord[j]
          r.z_recordType = that.data.recordTypes[r.recordType]

        }

        console.log(item)
        templist.push(item)
      }


      this.setData({
        records: templist,
        page: resData['paging']['page']
      })
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})