// pages/review_student/index.js
const request = require('../../api/teacher.js')
const utils = require('../../utils/util.js')
const app = getApp()

Page({

  /**
   * 页面的初始数据
   */
  data: {
    signSummaryId: "",
    recordDetail: {},
    showAuditBtn: true,
    /* 所有的小分类字典 */
    recordTypes: app.globalData.recordTypes,
    eatStates: {
      "less": "少",
      "normal": "正常",
      "more": "多"
    },
    //学生备注
    remark: '',
    //图片备注
    picRemark: '',
    studentName: '',
    kindergarten: '',
    sex: '',
    pictureIds: [],
    studentPicture: '/src/img/defaut_teacher_icon.png'
  },

  //加载详情
  getRecordDetailForSignId: function() {
    request.getRecordDetailForSignId(this.data.signSummaryId).then(res => {
      console.log(res)
      if (res) {
        var dateStr = res.recordDate.substr(0, 10)
        let show_day = new Array('周日', '周一', '周二', '周三', '周四', '周五', '周六');
        let date = new Date(dateStr);
        var num = date.getDay()
        res.recordDate = dateStr + " " + show_day[date.getDay()]



        this.setData({
          remark: res.remark,
          picRemark: res.pictureRemark
        })
        if (res.pictures != null) {
          this.data.pictureIds = res.pictures.split(",")
          var arrPic = []
          for (var i = 0; i < this.data.pictureIds.length; i++) {
            let id = this.data.pictureIds[i]
            arrPic.push(utils.handleImgShow(id))
          }

          this.setData({
            arrPic: arrPic
          })
        }


        // 饮食
        var dietRecords = res['dietRecord']
        for (var j = 0; j < dietRecords.length; j++) {
          var diet = dietRecords[j]
          diet.z_recordType = this.data.recordTypes[diet.recordType]
          diet.z_eatState = this.data.eatStates[diet.eatState]
        }

        // 睡觉
        var sleepRecord = res.sleepRecord
        for (var j = 0; j < sleepRecord.length; j++) {
          var r = sleepRecord[j]
          r.z_recordType = this.data.recordTypes[r.recordType]
        }

        // wc
        var wcRecord = res.wcRecord
        for (var j = 0; j < wcRecord.length; j++) {
          var r = wcRecord[j]
          r.z_recordType = this.data.recordTypes[r.recordType]
        }

        this.setData({
          showAuditBtn: res.state != "finish"
        })

        this.setData({
          recordDetail: res
        })
      }

    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      })
    })
  },

  auditSignSummary: function(signSummaryId) {
    console.log(signSummaryId)
    let record = this.data.recordDetail
    if (record.dietRecord.length == 0 && record.sleepRecord.length == 0 && record.wcRecord.length == 0) {
      wx.showToast({
        title: '没有记录，无法审批',
        icon: 'none',
      })
      return
    }

    request.auditSignSummary(signSummaryId).then(res => {
      this.setData({
        showAuditBtn: false
      })
      wx.showToast({
        title: '审核成功!',
        icon: 'none',
        duration: 2000
      })
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      })
    })

  },


  previewPic: function(e) {
    let index = e.target.dataset.picindex
    console.log(e)
    var current = this.data.arrPic[index]
    wx.previewImage({
      current: current,
      urls: this.data.arrPic
    })

  },

  tapCell: function(e) {
    //审核通过不允许修改
    // if (!this.data.showAuditBtn) {
    //   return;
    // }

  },

  operateTap: function(e) {
    this.auditSignSummary(this.data.signSummaryId)
  },

  operateEdit: function(e) {
    console.log(e)
    let student = this.data.recordDetail


    request.resetSignSummary(this.data.signSummaryId).then(res => {
      wx.showToast({
        title: '开始修改',
        icon: 'none',
        duration: 2000
      })
      wx.navigateTo({
        url: '/pages/add_record/index?studentIds=' + JSON.stringify([this.data.signSummaryId]) + '&pictureIds=' + JSON.stringify(this.data.pictureIds) + '&remark=' + (this.data.remark ? this.data.remark : '') + '&picRemark=' + (this.data.picRemark ? this.data.picRemark : ''),
      })
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      })
    })

  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    this.data.signSummaryId = options.signSummaryId;
    let remark = options.remark
    let picRemark = options.picRemark
    let studentPicture = options.studentPicture
    if (studentPicture != 'null') {
      this.setData({
        studentPicture: utils.handleImgShow(studentPicture)
      })
    }
    this.setData({
      studentName: options.studentName,
      sex: options.sex
    })

    // if (options.pictureIds != null) {
    //   this.data.pictureIds = JSON.parse(options.pictureIds)
    //   var arrPic = []
    //   for (var i = 0; i < this.data.pictureIds.length; i++) {
    //     let id = this.data.pictureIds[i]
    //     arrPic.push(utils.handleImgShow(id))
    //   }
    //   this.setData({
    //     arrPic: arrPic
    //   })
    // }


  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {
    this.getRecordDetailForSignId()
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})