//
//  NetworkAPI.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/11/30.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import Foundation
import Moya
import Alamofire
import SwiftyJSON

public enum Service {
    // MARK: - 登录
    case Login(String,String)
}

extension Service: TargetType {
    public var baseURL: URL {
        return URL(string: BaseUrl)!
    }
    
    public var path: String {
        switch self {
        case .Login(let name, _):
            return "测试"
        }
    }
    
    public var method: Moya.Method {
        return .post
    }
    
    public var sampleData: Data {
        return "Create post successfully".data(using: String.Encoding.utf8)!
    }
    
    public var task: Task {
        return .requestPlain
    }
    
    public var headers: [String : String]? {
        return ["device" : UIDevice.current.name]
    }
}












