//
//  AxisValueFormatter.swift
//  ChartsDemo-iOS
//
//  Created by Jacob Christie on 2017-07-09.
//  Copyright © 2017 jc. All rights reserved.
//

import Foundation
import Charts

public class ChartViewAxisValueFormatter: NSObject, IAxisValueFormatter {
    open var titleArray: Array<String>!
    
    public func stringForValue(_ value: Double, axis: AxisBase?) -> String {
        return titleArray[Int(value)] + ":00"
    }
}

public class AxisValueFormatter: NSObject, IAxisValueFormatter {
    
    public func stringForValue(_ value: Double, axis: AxisBase?) -> String {
        return "\(Int(value))" + "%"
    }
}

public class BarChartViewAxisValueFormatter: NSObject, IAxisValueFormatter {
    
    open var titleArray: Array<String>!
    
    public func stringForValue(_ value: Double, axis: AxisBase?) -> String {
        return titleArray[Int(value)]
    }
}

public class DigitValueFormatter: NSObject, IValueFormatter {
    
    public func stringForValue(_ value: Double, entry: ChartDataEntry, dataSetIndex: Int, viewPortHandler: ViewPortHandler?) -> String {
        let valueWithoutDecimalPart = String(format: "%.2f%%", value)
        return valueWithoutDecimalPart
    }
}

