//
//  NetworkAPI.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/11/30.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import Foundation
import Moya
import Alamofire
import SwiftyJSON

public enum Service {
    // MARK: - 登录
    case Login()
    // MARK: - 用于首页中查询当天累计客流人数、实时人数及当天各小时峰值
    case Spots(String,String)
    // MARK: - 景点区域密度查询
    case GETDensity(String,String)
}

extension Service: TargetType {
    public var baseURL: URL {
        return URL(string: "http://121.40.116.34:8077/")!
    }
    
    public var path: String {
        switch self {
        case .Login():
            return "User/Login"
        case .Spots(_ ,_):
            return "Spots/currentquery"
        case .GETDensity(_):
            return "Spots/GETDensity"
        }
    }
    
    public var method: Moya.Method {
        return .post
    }
    
    public var sampleData: Data {
        return "Create post successfully".data(using: String.Encoding.utf8)!
    }
    
    public var task: Task {
        switch self {
        case .Login():
            return .requestParameters(parameters: ["usercode": "SHZX",
                                                   "password": "SHZX"],
                                      encoding: JSONEncoding.default)
        case .Spots(let uuid,let time):
            return .requestParameters(parameters: ["useruuid": uuid,
                                                   "dateType": time,
                                                   "spotcode": "SHZX"],
                                      encoding: JSONEncoding.default)
        case .GETDensity(let uuid, let time):
            return .requestParameters(parameters: ["useruuid": uuid,
                                                   "dateType": time,
                                                   "spotcode": "SHZX"],
                                      encoding: JSONEncoding.default)
        }
    }
    
    public var headers: [String : String]? {
        return ["device" : UIDevice.current.name]
    }
}












