//
//	DensityResult.swift
//
//	Create by 云霄 曹 on 8/3/2018
//	Copyright © 2018. All rights reserved.
//	Model file generated using JSONExport: https://github.com/Ahmed-Ali/JSONExport

import Foundation 
import SwiftyJSON


class DensityResult : NSObject{

	var data : [DensityData]!
	var message : String!
	var success : Bool!

	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		data = [DensityData]()
		let dataArray = json["data"].arrayValue
		for dataJson in dataArray{
			let value = DensityData(fromJson: dataJson)
			data.append(value)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}
}

class DensityData : NSObject{
    
    var cameraDateTime : String!
    var codeType : String!
    var deviceGroup : String!
    var displayDensity : String!
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        cameraDateTime = json["CameraDateTime"].stringValue
        codeType = json["CodeType"].stringValue
        deviceGroup = json["DeviceGroup"].stringValue
        displayDensity = json["DisplayDensity"].stringValue
    }
    
    
}

