//
//	LoginResult.swift
//
//	Create by 云霄 曹 on 7/3/2018
//	Copyright © 2018. All rights reserved.
//	Model file generated using JSONExport: https://github.com/Ahmed-Ali/JSONExport

import Foundation 
import SwiftyJSON

class LoginResult : NSObject{
    
    var data : LoginData!
    var message : String!
    var success : Bool!
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        let dataJson = json["data"]
        if !dataJson.isEmpty{
            data = LoginData(fromJson: dataJson)
        }
        message = json["message"].stringValue
        success = json["success"].boolValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if data != nil{
            dictionary["data"] = data.toDictionary()
        }
        if message != nil{
            dictionary["message"] = message
        }
        if success != nil{
            dictionary["success"] = success
        }
        return dictionary
    }
}

class LoginData : NSObject{
    
    var spot : [Spot]!
    var isadmin : String!
    var name : String!
    var uuid : String!
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        spot = [Spot]()
        let spotArray = json["Spot"].arrayValue
        for spotJson in spotArray{
            let value = Spot(fromJson: spotJson)
            spot.append(value)
        }
        isadmin = json["isadmin"].stringValue
        name = json["name"].stringValue
        uuid = json["uuid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if spot != nil{
            var dictionaryElements = [[String:Any]]()
            for spotElement in spot {
                dictionaryElements.append(spotElement.toDictionary())
            }
            dictionary["Spot"] = dictionaryElements
        }
        if isadmin != nil{
            dictionary["isadmin"] = isadmin
        }
        if name != nil{
            dictionary["name"] = name
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        return dictionary
    }
}

class Spot : NSObject{
    
    var maxHeat : String!
    var maxblue : String!
    var maxrealtime : String!
    var maxred : String!
    var maxtotal : String!
    var maxyellow : String!
    var realmaxblue : String!
    var realmaxred : String!
    var realmaxyellow : String!
    var spotcode : String!
    var spotname : String!
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        maxHeat = json["maxHeat"].stringValue
        maxblue = json["maxblue"].stringValue
        maxrealtime = json["maxrealtime"].stringValue
        maxred = json["maxred"].stringValue
        maxtotal = json["maxtotal"].stringValue
        maxyellow = json["maxyellow"].stringValue
        realmaxblue = json["realmaxblue"].stringValue
        realmaxred = json["realmaxred"].stringValue
        realmaxyellow = json["realmaxyellow"].stringValue
        spotcode = json["spotcode"].stringValue
        spotname = json["spotname"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if maxHeat != nil{
            dictionary["maxHeat"] = maxHeat
        }
        if maxblue != nil{
            dictionary["maxblue"] = maxblue
        }
        if maxrealtime != nil{
            dictionary["maxrealtime"] = maxrealtime
        }
        if maxred != nil{
            dictionary["maxred"] = maxred
        }
        if maxtotal != nil{
            dictionary["maxtotal"] = maxtotal
        }
        if maxyellow != nil{
            dictionary["maxyellow"] = maxyellow
        }
        if realmaxblue != nil{
            dictionary["realmaxblue"] = realmaxblue
        }
        if realmaxred != nil{
            dictionary["realmaxred"] = realmaxred
        }
        if realmaxyellow != nil{
            dictionary["realmaxyellow"] = realmaxyellow
        }
        if spotcode != nil{
            dictionary["spotcode"] = spotcode
        }
        if spotname != nil{
            dictionary["spotname"] = spotname
        }
        return dictionary
    }
}

