//
//	SpotsResult.swift
//
//	Create by 云霄 曹 on 8/3/2018
//	Copyright © 2018. All rights reserved.
//	Model file generated using JSONExport: https://github.com/Ahmed-Ali/JSONExport

import Foundation 
import SwiftyJSON


class SpotsResult : NSObject{

	var data : [SpotsData]!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		data = [SpotsData]()
		let dataArray = json["data"].arrayValue
		for dataJson in dataArray{
			let value = SpotsData(fromJson: dataJson)
			data.append(value)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}
}

class SpotsData : NSObject{
    
    var hour : NSDictionary!
    var increase : NSDictionary!
    var realtimenumber : Int!
    var spotid : String!
    var time : String!
    var totalnumber : Int!
    var updatetimer : String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        hour = json["hour"].dictionaryObject! as NSDictionary
        increase = json["hour"].dictionaryObject! as NSDictionary
        realtimenumber = json["realtimenumber"].intValue
        spotid = json["spotid"].stringValue
        time = json["time"].stringValue
        totalnumber = json["totalnumber"].intValue
        updatetimer = json["updatetimer"].stringValue
    }
}
