//
//  GTOCollectionViewController.m
//  total
//  有效时间的选择
//  Created by freecui on 15/11/19.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOCollectionViewController.h"
static NSString *cellID = @"cellID";
@interface GTOCollectionViewController ()<UICollectionViewDataSource,UICollectionViewDelegate>//,UICollectionViewDelegateFlowLayout>
@property (nonatomic, strong) UICollectionView *c_collectionV;
@end

@implementation GTOCollectionViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"有效时间(h)";
    [self initSubViews];
}

- (void)initSubViews {
    
    UICollectionViewFlowLayout *flowLayout = [[UICollectionViewFlowLayout alloc]init];
    [flowLayout setScrollDirection:UICollectionViewScrollDirectionVertical];
    self.c_collectionV = [[UICollectionView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, 300) collectionViewLayout:flowLayout];
    [self.c_collectionV registerClass:[UICollectionViewCell class] forCellWithReuseIdentifier:cellID];
    self.c_collectionV.delegate = self;
    self.c_collectionV.dataSource = self;
    self.c_collectionV.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:self.c_collectionV];
}
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return 24;
}
- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView {
    return 1;
}
- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    UICollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:cellID forIndexPath:indexPath];
    [cell sizeToFit];
    if (!cell) {
        CLog(@"无法创建cell");
    }
   
    NSString *text = [NSString stringWithFormat:@"%ld",indexPath.row + 1];
    IBTUILabel *lbl = [[IBTUILabel alloc]initWithFrame:cell.bounds text: text font:[UIFont systemFontOfSize:15] tintColor:[UIColor blackColor] backgroundColor:nil textAlignment:NSTextAlignmentCenter];
    lbl.backgroundColor = GTO_BLUE_SHALLOW_TINT_COLOR;
    [cell.contentView addSubview:lbl];
    
    return cell;
}
//- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath {
//    return CGSizeMake(20, 20);
//}
//每个cell的间距
- (UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout insetForSectionAtIndex:(NSInteger)section {
    return UIEdgeInsetsMake(2, 1, 1, 2);
}
-(CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section {
    return 0;
}
//collectionViewDelete
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
//    CLog(@"choose%ld",indexPath.row);
    self.blockValideTime(indexPath.row + 1);
    [self PopViewControllerAnimated:YES];
}
- (BOOL)collectionView:(UICollectionView *)collectionView shouldSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    return YES;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
