//
//  InspectionAnswerViewController.m
//  patrol
//
//  Created by 曹云霄 on 2016/12/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "InspectionAnswerViewController.h"
#import "InspectionAnswerTableViewCell.h"
#import "InspectionAnswerSectionView.h"

@interface InspectionAnswerViewController ()

@end

@implementation InspectionAnswerViewController

#pragma mark - lazy
- (NSMutableArray *)browserArray
{
    if (!_browserArray) {
        _browserArray = [NSMutableArray array];
    }
    return _browserArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
}

#pragma mark - 父视图传入的section闭合控制数组
- (void)setClosedControlArray:(NSMutableArray *)closedControlArray
{
    _closedControlArray = closedControlArray;
    [self.tableView reloadData];
}

#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    
    return self.datasArray.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    return 1;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    InspectionAnswerTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:[InspectionAnswerTableViewCell className] forIndexPath:indexPath];
    cell.answerModel = self.datasArray[indexPath.section];
    cell.indexPath = indexPath;
    return cell;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section{
    
    InspectionAnswerSectionView *headerView = [tableView dequeueReusableCellWithIdentifier:[InspectionAnswerSectionView className]];
    headerView.contentView.tag = section;
    [headerView.contentView addGestureRecognizer:[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(planDetailsSectionClick:)]];
    headerView.boolValue = [self.closedControlArray[section] boolValue];
    headerView.questionModel = self.datasArray[section];
    return headerView.contentView;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    BOOL boolValue = [self.closedControlArray[indexPath.section] boolValue];
    CGFloat rowHeight = 0;
    if (boolValue) {
        rowHeight = [self.rowHeightArray[indexPath.section] floatValue];
    }
    return rowHeight;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return [self.sectionHeightArray[section] floatValue];
}

#pragma mark - Section Click
- (void)planDetailsSectionClick:(UITapGestureRecognizer *)sender
{
    NSInteger senderIndex = sender.view.tag;
    BOOL boolValue = [self.closedControlArray[senderIndex] boolValue];
    boolValue = !boolValue;
    self.closedControlArray[senderIndex] = [NSNumber numberWithBool:boolValue];
    if ([self.delegate respondsToSelector:@selector(refreshSuperTableView)]) {
        [self.delegate refreshSuperTableView];
    }
}



@end
