//
//  InspectionPhotoViewController.m
//  patrol
//
//  Created by 曹云霄 on 2016/12/31.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "InspectionPhotoViewController.h"
#import "InspectionPhotoCollectionViewCell.h"

@interface InspectionPhotoViewController ()

@end

@implementation InspectionPhotoViewController

static NSString * const reuseIdentifier = @"InspectionPhotoCollectionViewCell";

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpCollectionView];
}

- (void)setAttachmentArray:(NSArray *)attachmentArray
{
    _attachmentArray = attachmentArray;
    [self.collectionView reloadData];
}

#pragma mark - FlowLayout
- (void)setUpCollectionView
{
    self.inspectionCollectionFlowLayout.itemSize = CGSizeMake((ScreenSize.width-60)/3.0, (ScreenSize.width-60)/3.0);
    self.inspectionCollectionFlowLayout.minimumLineSpacing = 15;
    self.inspectionCollectionFlowLayout.minimumInteritemSpacing = 15;
}

#pragma mark <UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {

    return self.attachmentArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    
    InspectionPhotoCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:reuseIdentifier forIndexPath:indexPath];
    [cell.inspectionImageView sd_setImageWithURL:[NSURL URLWithString:[self.attachmentArray yx_objectAtIndex:indexPath.item]                                                                      [@"fileUrl"]] placeholderImage:KNODATAIMAGE];
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    PYPhotoBrowseView *photoBroseView = [[PYPhotoBrowseView alloc] init];
    photoBroseView.currentIndex = indexPath.item;
    NSMutableArray *imageArray = [NSMutableArray array];
    for (InspectionPhotoCollectionViewCell *cell in collectionView.visibleCells) {
        [imageArray addObject:cell.inspectionImageView];
    }
    photoBroseView.sourceImgageViews = imageArray;
    [photoBroseView show];
}


@end
