//
//  InspectionPlanTableViewCell.h
//  patrol
//
//  Created by 曹云霄 on 16/9/1.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "InspectionResultModel.h"
/**
 *  门店点击事件
 */
@protocol InspectionPlanClickEventDelegate <NSObject>

@optional

/**
 *  门店详情
 *
 *  @param indexPath  点击位置
 *  @param inspectors VI检查员
 *  @param uuid       VI检查计划UUID
 */
- (void)storesClickEvent:(NSIndexPath *)indexPath inspectionPerson:(Inspectors *)inspectors planResults:(Results *)result planUuid:(NSString *)uuid;

@end

@interface InspectionPlanTableViewCell : UITableViewCell<UITableViewDelegate,UITableViewDataSource>

/**
 *  PlanDetailsTableView
 */
@property (weak, nonatomic) IBOutlet UITableView *supervisionTableView;

/**
 *  代理
 */
@property (nonatomic,weak) id<InspectionPlanClickEventDelegate>delegate;

/**
 *  数据源
 */
@property (nonatomic,strong) Records *planResultModel;


@end
