//
//  InspectionPlanViewController.m
//  patrol
//
//  Created by 曹云霄 on 16/9/7.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "InspectionPlanViewController.h"
#import "InspectionTableViewCell.h"


@interface InspectionPlanViewController ()<UISearchBarDelegate,UITableViewDelegate,UITableViewDataSource>

/**
 *  显示数据
 */
@property (nonatomic,strong) NSArray *displayArray;

@end

@implementation InspectionPlanViewController

#pragma mark - lazy
- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.displayArray = [NSArray arrayWithArray:self.datasArray];
    self.searchView.placeholder = [NSString stringWithFormat:@"搜索%@",self.title];
}

#pragma mark - searchbar delegate
- (BOOL)searchBarShouldBeginEditing:(UISearchBar *)searchBar {
    searchBar.showsCancelButton = YES;
    return YES;
}

- (void)searchBarCancelButtonClicked:(UISearchBar *)searchBar {
    searchBar.showsCancelButton = NO;
    searchBar.text = nil;
    [[UIApplication sharedApplication].keyWindow endEditing:YES];
    self.displayArray = [NSArray arrayWithArray:self.datasArray];
    [self.inspectionPlanTableView reloadData];
}

- (void)searchBar:(UISearchBar *)searchBar textDidChange:(NSString *)searchText {
    NSPredicate *pred = [NSPredicate predicateWithFormat:@"name contains [cd] %@ OR value contains [cd] %@", searchText, searchText];
    self.displayArray = [self.datasArray filteredArrayUsingPredicate:pred];
    if (searchText.length < 1) {
        self.displayArray = [NSArray arrayWithArray:self.datasArray];
    }
    [self.inspectionPlanTableView reloadData];
}


#pragma mark - tableview
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    InspectionTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"InspectionTableViewCell" forIndexPath:indexPath];
    cell.taskNameLabel.text = [self.displayArray yx_objectAtIndex:indexPath.row][@"name"];
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.displayArray.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    [self popViewControllerAnimated:YES];
    if (self.selectInspectionTaskBlock) {
        self.selectInspectionTaskBlock([self.displayArray yx_objectAtIndex:indexPath.row]);
    }
}





@end
