//
//  InspectionAnswerSectionView.m
//  patrol
//
//  Created by 曹云霄 on 2016/12/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "InspectionAnswerSectionView.h"

@implementation InspectionAnswerSectionView

- (void)awakeFromNib {
    [super awakeFromNib];
}

- (void)setBoolValue:(BOOL)boolValue
{
    _boolValue = boolValue;
    self.arrowImageView.transform = boolValue?CGAffineTransformMakeRotation(M_PI/2):CGAffineTransformMakeRotation((0));
}

#pragma mark - 问题数据源
- (void)setQuestionModel:(NewAnswers *)questionModel
{
    _questionModel = questionModel;
    self.titleLabel.text = questionModel.questionTitle;
    self.titleLabel.textColor = questionModel.answered ? GTO_BLUE_DEEP_COLOR : [UIColor redColor];
    self.scoreLabel.textColor = questionModel.answered ? GTO_BLUE_DEEP_COLOR : [UIColor redColor];
    self.scoreLabel.text = questionModel.answered ? [NSString stringWithFormat:@"%.2f%@",[questionModel.score floatValue],@"分"] : @"--";
    if (questionModel.answered) {
        self.scoreLabel.hidden = !questionModel.score;
    }
}


@end
