
//
//  GTOBusinessItem.m
//  total
//
//  Created by freecui on 15/9/10.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOBusinessItem.h"
#import "GTOFunctionEntity.h"
#define padding  20
#define btn_padding 10
#define lblViewItem_bg_color [UIColor colorWithRed:175 green:202 blue:219 alpha:1.0]
@implementation GTOBusinessItem
- (instancetype)initWithFrame:(CGRect)frame labelTitle:(NSString *)lblTitle functionEntityArray:(NSArray *)array {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    CGFloat topPadding = 10;
    CGFloat viewH = frame.size.height - 2 * topPadding;
    CGFloat lblW = frame.size.width - 2 * padding;
    CGFloat btnW =  (lblW - 2.0 * btn_padding ) / 3.0;
    CGFloat btnH = btnW / 4.0 * 3.0;
    CGFloat lineH =( viewH - btnH ) /5.0 * 3.0;
    CGFloat lblH = viewH - btnH - lineH;
    
    IBTUILabel *titleLbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(padding, topPadding, lblW , lblH)];
    titleLbl.font = [UIFont fontWithName:@"Helvetica-Bold" size:14];
    titleLbl.text = lblTitle;
    titleLbl.tintColor = [UIColor blackColor];
    titleLbl.backgroundColor = lblViewItem_bg_color;
    titleLbl.textAlignment = NSTextAlignmentLeft;
    titleLbl.layer.masksToBounds = YES;
    titleLbl.layer.cornerRadius = 2;
    [self addSubview:titleLbl];
    
    for (int count = 0; count < array.count; count ++) {
        GTOFunctionEntity *functionEntity = (GTOFunctionEntity *)array[count];
//        UIView *viewItem = [[UIView alloc]init];
//        viewItem.backgroundColor = lblViewItem_bg_color;
//        viewItem.tag = functionEntity.functionBtnTag;
//        
//        UIImageView *imgV = [UIImageView alloc]init
//        IBTUILabel *lbl = [IBTUILabel alloc]initWithFrame:<#(CGRect)#> text:<#(NSString *)#> font:<#(UIFont *)#> tintColor:<#(UIColor *)#> backgroundColor:<#(UIColor *)#> textAlignment:<#(NSTextAlignment)#>

        CGRect rect = CGRectMake(padding + (btn_padding + btnW) * count, titleLbl.bottom, btnW, btnH + lineH);
        
        
        if (array.count == 2) {
            if (count == 1) {
                rect = CGRectMake(padding + (btn_padding + btnW) * (count + 1), titleLbl.bottom, btnW, btnH + lineH);
            }
    
        }
        UIView *viewItem = [self p_viewWithFrame: CGRectMake(0, lineH, btnW, btnH) imageName:functionEntity.iconName lableText:functionEntity.functionName];
        UIButton *btn = [[UIButton alloc]initWithFrame:viewItem.bounds];
        btn.backgroundColor = [UIColor clearColor];
        btn.tag = functionEntity.functionBtnTag;
        [btn addTarget:self action:@selector(btnClicked:) forControlEvents:UIControlEventTouchUpInside];
        [viewItem addSubview:btn];
       // UIView *view = [self p_lineAndBtnWithFrame:rect lineHeight:lineH buttonHeight:btnH button:btn];
        UIView *view = [self p_lineAndBtnWithFrame:rect lineHeight:lineH buttonHeight:btnH viewItem:viewItem];
        [self addSubview:view];
    }
    
    return self;
}


//带线和button的view
- (UIView *)p_lineAndBtnWithFrame: (CGRect)frame
                       lineHeight: (CGFloat)lineH
                     buttonHeight: (CGFloat)btnH
                           viewItem: (UIView *)viewItem {
    UIView *view = [[UIView alloc]initWithFrame:frame];
    UIView *line = [[UIView alloc]initWithFrame:CGRectMake((view.width - 1.0 ) / 2.0, 0, 1, lineH)];
    line.backgroundColor = [UIColor blackColor];
   // viewItem.frame = CGRectMake(0, line.bottom, frame.size.width, btnH);
    [view addSubview:line];
    [view addSubview:viewItem];
    
    return view;
}
- (UIView *)p_viewWithFrame: (CGRect)frame
                imageName: (NSString *)imgName
                lableText: (NSString *)lblText {
    UIView *view = [[UIView alloc]initWithFrame:frame];
    IBTUILabel *lbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(0, view.height - 15, view.width, 10) text:lblText font:[UIFont systemFontOfSize:12] tintColor:[UIColor blackColor] backgroundColor:[UIColor clearColor] textAlignment:NSTextAlignmentCenter];
    CGFloat imgVH = view.height - 5 - (view.height - lbl.y ) - 5;
    UIImageView *imgV = [[UIImageView alloc]initWithFrame:CGRectMake((view.width - imgVH ) * 0.5, 5,imgVH , imgVH)];
    imgV.image = [UIImage imageNamed:imgName];
    [view addSubview:lbl];
    [view addSubview:imgV];
    
    view.backgroundColor = lblViewItem_bg_color;
    view.layer.cornerRadius = 4;
    view.layer.masksToBounds = YES;

    return view;
}
// button action
- (void)btnClicked: (IBTUIButton *)btn {
    if ([_delegate respondsToSelector:@selector(businessItemButtonClickedWithBtnTag:)]) {
        [_delegate businessItemButtonClickedWithBtnTag:btn.tag];
    }
}
@end
