//
//  AirplaneModeViewController.m
//  total
//
//  Created by 曹云霄 on 2018/1/17.
//  Copyright © 2018年 Delevin. All rights reserved.
//

#import "AirplaneModeViewController.h"
#import "AirplaneModeTableViewCell.h"
@interface AirplaneModeViewController ()<UITableViewDelegate,UITableViewDataSource>

@end

@implementation AirplaneModeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark -UI
- (void)uiConfigAction {
    self.view.backgroundColor = [UIColor colorWithWhite:0 alpha:0.5];
}

#pragma mark -数据源
- (void)setDatasArray:(NSArray<NSString *> *)datasArray
{
    _datasArray = datasArray;
    [self.airplanModeTableView reloadData];
}

#pragma mark -确认
- (IBAction)sureButtonClickAction:(UIButton *)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark -<UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    AirplaneModeTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"AirplaneModeTableViewCell" forIndexPath:indexPath];
    cell.airplanModeTitleLabel.text = self.datasArray[indexPath.row];
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.datasArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 40;
}









@end
