//
//  PatrolStandardViewController.m
//  patrol
//
//  Created by Javen on 2017/3/3.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "PatrolStandardViewController.h"
#import "ZJStandardPictureTableViewCell.h"
#import "ZJStandardTitleTableViewCell.h"
#import "UploadManager.h"
#import "RequestManager.h"
@interface PatrolStandardViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (weak, nonatomic) IBOutlet UITableView *tableView;
@property (strong, nonatomic) NSMutableArray *arrPictures;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *constrainToBottom;
@property(nonatomic, strong) NSMutableArray *browserArray;
@property (weak, nonatomic) IBOutlet UIButton *backButton;
@end

@implementation PatrolStandardViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.tableView.rowHeight = UITableViewAutomaticDimension;
    self.tableView.estimatedRowHeight = 88;
    [self.backButton setTitle:@"返回" forState:UIControlStateNormal];
//    if ([UploadManager getUploadType] == UPLOAD_COMMON) {
//        [RequestManager request_PatrolInspectAttachment:self.question.attachmentId success:^(id returnValue) {
//            if ([returnValue[@"success"] boolValue] == YES) {
//                NSMutableArray *pictures = [NSMutableArray array];
//                for (NSInteger i = 0; i < [returnValue[@"data"] count]; i++) {
//                    NSDictionary *dict = returnValue[@"data"][i];
//                    PostAttachmentModel *model = [[PostAttachmentModel alloc] initWithDictionary:dict error:nil];
//                    [pictures addObject:model];
//                }
//                self.arrPictures = pictures;
//                [self.tableView reloadData];
//                [self configHeightWithAttachment];
//            }
//
//        } failure:^(id errorValue) {
//            [IBTLoadingView showTextOnly:errorValue];
//        }];
//    }else{
        self.arrPictures = [NSMutableArray array];
        for (ZJPatrolDetail_questions_attachmentUrls *att in self.question.attachmentUrls) {
            PostAttachmentModel *model = [[PostAttachmentModel alloc] initWithDictionary:att.toDictionary error:nil];
            [self.arrPictures addObject:model];
        }
        [self configHeightWithAttachment];
        [self.tableView reloadData];
//    }
}

- (void)configHeightWithAttachment {
    if (self.arrPictures.count == 0) {
        self.constrainToBottom.constant = ScreenSize.width - 60 - 360;
    }
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 1 + self.arrPictures.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        ZJStandardTitleTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ZJStandardTitleTableViewCell" forIndexPath:indexPath];
        cell.labelTitle.text = self.question.title;
        
        NSData *data = [self.question.reference dataUsingEncoding:NSUnicodeStringEncoding];
        NSDictionary *options = @{NSDocumentTypeDocumentAttribute: NSHTMLTextDocumentType};
        NSMutableAttributedString *html = [[NSMutableAttributedString alloc]initWithData:data
                                                                   options:options
                                                        documentAttributes:nil
                                                                     error:nil];
        [html addAttribute:NSFontAttributeName value:[UIFont systemFontOfSize:15] range:NSMakeRange(0, html.length)];
        cell.labelContent.attributedText = html;
        cell.labelImageTitle.hidden = self.arrPictures.count == 0;
        cell.labelImageTitle.text = [NSString stringWithFormat:@"参考图片(%ld)：",self.arrPictures.count];
        return cell;
    }else{
        PostAttachmentModel *model = self.arrPictures[indexPath.row - 1];
        ZJStandardPictureTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ZJStandardPictureTableViewCell" forIndexPath:indexPath];
        NSString *extractedExpr = [ToolsManager viJointUrl:model.fileUrl];
        [cell.img sd_setImageWithURL:[NSURL URLWithString:extractedExpr] placeholderImage:KNODATAIMAGE];
        return  cell;
         }
    return nil;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row > 0) {
        NSMutableArray *imageArray = [NSMutableArray array];
        PYPhotoBrowseView *photoBroseView = [[PYPhotoBrowseView alloc] init];
        for (PostAttachmentModel *model in self.arrPictures) {
            [imageArray addObject:[ToolsManager viJointUrl:model.fileUrl]];
        }
        photoBroseView.imagesURL = imageArray;
        photoBroseView.currentIndex = indexPath.row - 1;
        [photoBroseView show];
    }
}


@end
