//
//  PatrolTempCheckViewController.m
//  total
//
//  Created by 曹云霄 on 2017/12/4.
//  Copyright © 2017年 Delevin. All rights reserved.
//

#import "PatrolTempCheckViewController.h"
#import "FilterDetailViewController.h"
#import "IBTFileManager.h"
#import "PatrolTaskViewController.h"
#import "PatrolExamViewController.h"

@interface PatrolTempCheckViewController ()

/**
 选中门店
 */
@property (weak, nonatomic) IBOutlet UILabel *selectedStoreLabel;

/**
 背景View
 */
@property (weak, nonatomic) IBOutlet UIView *contentBgView;

/**
 油站列表
 */
@property (nonatomic, strong) FilterDetailViewController *storeDetailVc;

/**
 选择油站
 */
@property (nonatomic, strong) FilterSearchModel *selectedStoreModel;

@end

@implementation PatrolTempCheckViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addStoreChildVc];
    [self addHistoryButtonItem];
    self.title = @"VI抽查";
}

#pragma mark -布局完成
- (void)viewDidLayoutSubviews
{
    self.storeDetailVc.view.frame = self.contentBgView.bounds;
}

#pragma mark -添加历史按钮
- (void)addHistoryButtonItem
{
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"历史" style:UIBarButtonItemStyleDone target:self action:@selector(historyButtonItemAction)];
}

#pragma mark -临时检查历史
- (void)historyButtonItemAction {
    PatrolTaskViewController *patrolTask = [PatrolTaskViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_PATROLINSPECT];
    patrolTask.isTempTask = YES;
    [self PushViewController:patrolTask animated:YES];
}

#pragma mark -添加油站列表控制器
- (void)addStoreChildVc
{
    [self.contentBgView addSubview:self.storeDetailVc.view];
    [IBTLoadingView showProgressLabel:@"获取门店中"];
    [HttpRequestManager requestNetworkwithURL:[NSString stringWithFormat:@"%@/mdata/store/getsByUser2/%@",VIHTTP_REST_API_BASE_URL,[ICRUserUtil sharedInstance].f_user_uuid] withRequestType:ONE withParameter:nil withSuccess:^(id returnValue) {
        [IBTLoadingView hideHUDWithText:nil];
        if ([returnValue[@"success"] isEqualToNumber:@1]) {
            NSArray *stores = returnValue[@"data"];
            NSMutableArray *storyArray = [NSMutableArray array];
            for (NSDictionary *dict in stores) {
                FilterSearchModel *searchModel = [[FilterSearchModel alloc] init];
                searchModel.name = [NSString stringWithFormat:@"[%@]%@",dict[@"code"],dict[@"name"]];
                searchModel.uuid = dict[@"uuid"];
                [storyArray addObject:searchModel];
            }
            WS(weakSelf);
            [weakSelf.storeDetailVc setSelectedItemBlock:^(NSIndexPath *indexPath, FilterSearchModel *model) {
                weakSelf.selectedStoreLabel.text = model.isSelected ? model.name : @"---";
                weakSelf.selectedStoreModel = model.isSelected ? model : nil;
            }];
            weakSelf.storeDetailVc.filterArray = storyArray;
        }
    } withFailed:^(NSError *failed) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTextOnly:failed.localizedDescription];
    }];
}

#pragma mark -下一步(生成VI检查任务)
- (IBAction)nextButtonClickAction:(UIButton *)sender {
    if (!self.selectedStoreModel) {
        [IBTLoadingView showTextOnly:@"请先选择油站"];
        return;
    }
    WS(weakSelf);
    ShowAlertView(@"提示", @"您确定对此门店发起VI临时检查任务吗?", @[@"取消",@"确认"], UIAlertControllerStyleAlert, ^(NSInteger index) {
        if (index == ONE) {
            [IBTLoadingView showProgressLabel:@"加载中"];
            [RequestManager request_CreatePatrolTempCheck:weakSelf.selectedStoreModel.uuid success:^(id returnValue) {
                [IBTLoadingView hideHUDWithText:nil];
                if ([ BaseViewModel verifyData:returnValue]) {
                    [IBTLoadingView showTextOnly:@"生成VI抽查任务成功"];
                    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                        ZJPatrolDetail *detail = [ZJPatrolDetail modelWithDic:[BaseViewModel formatData:returnValue]];
                        PatrolTaskCustomModel *customModel = [PatrolTaskCustomModel new];
                        customModel.uuid = detail.uuid;
                        Results *result = [Results new];
                        result.store_uuid = weakSelf.selectedStoreModel.uuid;
                         PatrolExamViewController *examVC = [PatrolExamViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_PATROLINSPECT];
                         PatrolExamViewModel *viewVM = [PatrolExamViewModel new];
                         viewVM.storeResult = result;
                         viewVM.plan = customModel;
                         examVC.viewModel = viewVM;
                        examVC.isBackRootVc = YES;
                         [weakSelf pushViewController:examVC animated:YES];
                    });
                }else {
                    [IBTLoadingView showTextOnly:[BaseViewModel messageData:returnValue]];
                }
            } failure:^(id errorValue) {
                [IBTLoadingView hideHUDWithText:nil];
                [IBTLoadingView showTextOnly:errorValue];
            }];
        }
    });
}

#pragma mark -lazy
- (FilterDetailViewController *)storeDetailVc
{
    if (!_storeDetailVc) {
        _storeDetailVc = [FilterDetailViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_FILTER];
        _storeDetailVc.isContentVc = YES;
    }
    return _storeDetailVc;
}


@end
