//
//  GTOQSingleSelectViewController.m
//  Cruiser
//
//  Created by Xummer on 6/7/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "GTOQSingleScoreViewController.h"
#import "GTOQuestionManager.h"

static NSString *kCellID = @"cellID";

@interface GTOQSingleScoreViewController ()
<
UITableViewDataSource,
UITableViewDelegate
>

@property (strong, nonatomic) IBTTableView *m_tableView;
@property (strong, nonatomic) NSIndexPath *m_currentIndexP;

@end

@implementation GTOQSingleScoreViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    for (NSDictionary *dict in self.d_answer.resultDetails) {
        NSIndexPath *indexP =
        [NSIndexPath indexPathForRow:[dict[ @"index" ] unsignedIntegerValue]-1 inSection:0];
        self.m_currentIndexP = indexP;
        [_m_tableView selectRowAtIndexPath:indexP animated:NO scrollPosition:UITableViewScrollPositionNone];
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method

- (void)initScrollViewWithRect:(CGRect)rect {//重写父类的方法
    
    self.m_tableView = [[IBTTableView alloc] initWithFrame:rect style:UITableViewStylePlain];
    _m_tableView.bHandleKeyboard = YES;
    _m_tableView.backgroundColor = [UIColor clearColor];
    _m_tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [_m_tableView registerClass:[IBTTableViewCell class] forCellReuseIdentifier:kCellID];
    _m_tableView.dataSource = self;
    _m_tableView.delegate = self;
    
    self.c_contentScrollView = _m_tableView;
    [self.view addSubview:_m_tableView];
    
    if (self.d_notEdit) {
        self.m_tableView.userInteractionEnabled = NO;
    }

}

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section
{
    return self.d_question.details.count;//self.m_arrOptions.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellID forIndexPath:indexPath];
    cell.backgroundColor = [UIColor clearColor];
    [self configureCell:cell forRowAtIndexPath:indexPath];
    
    if (self.m_currentIndexP && self.m_currentIndexP.row == indexPath.row) {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    }
    else {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    
    return cell;
}

- (void)configureCell:(UITableViewCell *)cell
    forRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    NSDictionary *dicOptionItem = self.d_question.details[indexPath.row];//self.m_arrOptions[ indexPath.row ];
    cell.textLabel.text =[NSString stringWithFormat:@"%@ .%@:  %@分",[GTOCommonTools stringLetterWithNumber:indexPath.row],dicOptionItem[@"value"],dicOptionItem[ @"score" ]] ;//[ @"productName" ];
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView
didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView cellForRowAtIndexPath:self.m_currentIndexP];
    cell.accessoryType = UITableViewCellAccessoryNone;
    
    self.m_currentIndexP = indexPath;
    
    cell = [tableView cellForRowAtIndexPath:self.m_currentIndexP];
    cell.accessoryType = UITableViewCellAccessoryCheckmark;
    
    NSString *deUuid = [NSString string];
    NSDictionary *dicOptionItem = self.m_arrOptions[ indexPath.row ];
    if (self.d_answer.resultDetails.count > 0) {
        NSDictionary *dict = self.d_answer.resultDetails[0];
        GTOAnswerDetail *dE = [GTOAnswerDetail DBObject];
        [dE praseFromJsonDict:dict];
        deUuid = dE.uuid;
    }
    
    GTOAnswerDetail *dE = [GTOAnswerDetail DBObject];
    if (deUuid.length > 0) {
        dE.uuid = deUuid;
    } else {
        dE.uuid = [[ICRUserUtil sharedInstance] mobileID];//随机生成的唯一标识
    }
    dE.index = [dicOptionItem[ @"index" ] unsignedIntegerValue];
    dE.numberValue = [dicOptionItem[ @"score" ] unsignedIntegerValue];
    dE.stringValue = dicOptionItem[ @"value" ] ;
    self.d_answer.resultScore = dE.numberValue;
    self.d_answer.resultDetails = @[ [dE dictForCommit] ];
    
}

#pragma mark - Actions
- (void)onNextBtnAction:(__unused id)sender {
    if (self.d_notEdit) {
        [super disMissSelf];
        return;
    }
    
    if ([self.d_answer.resultDetails count] <= 0) {
        self.d_answer.bIsAnswered = NO;
        return;
    }
    //self.d_answer.uuid = [[ICRUserUtil sharedInstance] mobileID];//随机生成的唯一标识
    self.d_answer.bIsAnswered = YES;
//    self.d_answer.resultRemark = self.c_helperView.m_inputTxtF.text;
    
    GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
    UIViewController *qVC = [mgr questionViewControlAtIndex:self.d_questionIndex + 1];
    if (qVC) {
        [self PushViewController:qVC animated:YES];
    }
    else {
        [super disMissSelf];
      //  [self openResultView];
    }
    


    [self.d_answer saveToDBWithHandleData:NULL
                             complete:^{
                                 [IBTLoadingView hideHUDWithText:nil];
                 
                                 
                             }
                                 fail:^(NSError *error) {
                                     
                                     [IBTLoadingView hideHUDWithText:error.localizedDescription];
                                 }];
}

//- (void) onBeforeBtnAction:(id)sender {
//
//    GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
//    UIViewController *qVC = [mgr questionViewControlAtIndex:self.m_uiIndex + 1];
//    if (qVC) {
//        [self PushViewController:qVC animated:YES];
//    }
//    else {
//        [self openResultView];
//    }
//
//}
@end
