
//
//  GTOPatrolPlanResultTopItem.m
//  total
//  拓站任务列表的cell的内容
//  Created by freecui on 15/9/28.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOPioneeringAddressInfoView.h"
#import "GTOPioneering.h"
#import "GTOInspector.h"

@interface GTOPioneeringAddressInfoView ()
@property (strong, nonatomic) IBTUILabel *m_titleLabel;

@property (strong, nonatomic) IBTUILabel *m_templateLabel;
@property (strong, nonatomic) IBTUILabel *m_beginDateLabel;//
@property (strong, nonatomic) IBTUILabel *m_remarkLabel;//



@property (nonatomic, assign) CGFloat d_processLength;//进度条长度
@end
@implementation GTOPioneeringAddressInfoView


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    
    self.m_titleLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:17] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_templateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_beginDateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_remarkLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];

    
    [self addSubview:_m_titleLabel];
    [self addSubview:_m_templateLabel];
    [self addSubview:_m_beginDateLabel];
    [self addSubview:_m_remarkLabel];

    
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_titleLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    _m_templateLabel.frame = (CGRect){
        .origin.x = _m_titleLabel.x,
        .origin.y = _m_titleLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    
    _m_beginDateLabel.frame = (CGRect){
        .origin.x = _m_titleLabel.x,
        .origin.y = _m_templateLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = self.width,
        .size.height = lblH,
    };
    _m_remarkLabel.frame = (CGRect){
        .origin.x =_m_titleLabel.x,
        .origin.y = _m_beginDateLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
}

@end

@implementation GTOPioneeringAddressInfoView (configure)
- (void)updateWithPioneering: (GTOPioneering *)pioneering
{
    self.m_titleLabel.text = [NSString stringWithFormat:@"拓站标题：%@ ",pioneering.title];
    self.m_templateLabel.text = [NSString stringWithFormat:@"拓站人员：%@ ",
                                 pioneering.pioneer_name];
    self.m_beginDateLabel.text = [NSString stringWithFormat:@"开始时间：%@",pioneering.beginDate ];
    self.m_remarkLabel.text = [NSString stringWithFormat:@"备注：%@",pioneering.remark];

    
    [self layoutSubviews];
    
    
}
@end
