//
//  GTOLicenceResultHeaderContentView.m
//  total
//
//  Created by freecui on 15/11/3.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOLicenceResultHeaderContentView.h"

@interface GTOLicenceResultHeaderContentView ()
@property (strong, nonatomic) IBTUILabel *m_titleLabel;

@property (assign, nonatomic) BOOL m_isSeePosition;
@end
@implementation GTOLicenceResultHeaderContentView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    self.m_isSeePosition =  NO;
    [self initSubViews];
    return self;
}
- (instancetype)initWithFrame:(CGRect)frame isSeePosition: (BOOL)isSeePosition {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    self.m_isSeePosition = isSeePosition;
    [self initSubViews];
    return self;
}
- (void)initSubViews {
    
    self.m_titleLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:20] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:XXFBgColor textAlignment:NSTextAlignmentLeft];
    
    self.m_positionBtn = [IBTUIButton buttonWithTitle:@"查看位置" textColor:GTO_BLUE_DEEP_COLOR textFont:[UIFont systemFontOfSize:17] backColor: XXFBgColor ];
    [self.m_positionBtn.titleLabel setTextAlignment:NSTextAlignmentRight];
    [self addSubview:_m_titleLabel];
    if (_m_isSeePosition) {
        [self addSubview:_m_positionBtn];
        
    }
    
}

- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_titleLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = (SCREEN_SIZE.width - 2 *GTO_LEFT_PADDING) * 0.5,
        .size.height = lblH + 10,
    };
    _m_positionBtn.frame = (CGRect){
        .origin.x = _m_titleLabel.right,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = _m_titleLabel.width,
        .size.height = lblH + 10,
    };
}
//- (void)seePositionClicked {
//    
//}
@end

@implementation GTOLicenceResultHeaderContentView (configure)
- (void)updateWithString:(NSString *)string {
    self.backgroundColor = XXFBgColor;
    self.m_titleLabel.text = string;
    [self layoutSubviews];
}

@end
