
//
//  GTOPatrolPlanResultTopItem.m
//  total
//  许可证结果中的的top的cell
//  Created by freecui on 15/9/28.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOLicenceResultTopCellContentView.h"
#import "GTOLicence.h"
#import "GTORepair.h"
#import "GTODisplayResult.h"
@interface GTOLicenceResultTopCellContentView ()
@property (strong, nonatomic) IBTUILabel *m_billNumberLabel;
@property (strong, nonatomic) IBTUILabel *m_riskGradeLabel;
@property (strong, nonatomic) IBTUILabel *m_storeNameLabel;//完成进度
@property (strong, nonatomic) IBTUILabel *m_licenceTypeLabel;
@property (strong, nonatomic) IBTUILabel *m_valideTimeStartLabel;
@property (strong, nonatomic) IBTUILabel *m_valideTimeEndLabel;
@property (strong, nonatomic) IBTUILabel *m_requestDateLabel;//申请时间
@property (strong, nonatomic) IBTUILabel *m_rejectCauseLabel;//拒绝原因;

@property (strong, nonatomic) IBTUILabel *m_processLabel;//完成进度
@property (strong, nonatomic) IBTUILabel *m_processValueLabel;
@property (strong, nonatomic) IBTUILabel * m_processFractionLabel;
@property (strong, nonatomic) IBTUIView *m_processBarView;

@property (nonatomic, assign) CGFloat d_processLength;//进度条长度
@end
@implementation GTOLicenceResultTopCellContentView


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_billNumberLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_riskGradeLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_storeNameLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_licenceTypeLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_valideTimeStartLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_valideTimeEndLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_requestDateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_rejectCauseLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    
    
    self.m_processLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processValueLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processFractionLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentRight];
    
    [self addSubview:_m_billNumberLabel];
    [self addSubview:_m_riskGradeLabel];
    [self addSubview:_m_storeNameLabel];
    [self addSubview:_m_licenceTypeLabel];
    [self addSubview:_m_valideTimeStartLabel];
    [self addSubview:_m_valideTimeEndLabel];
    [self addSubview:_m_requestDateLabel];
    [self addSubview:_m_rejectCauseLabel];

    [self addSubview:_m_processLabel];
    [self addSubview:_m_processValueLabel];
    [self addSubview:_m_processFractionLabel];
    
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_billNumberLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    CGFloat leftX = _m_billNumberLabel.x;
    CGFloat lblW = _m_billNumberLabel.width;
    _m_riskGradeLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_billNumberLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = lblW,
        .size.height = lblH,
    };
    _m_storeNameLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_riskGradeLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = lblW,
        .size.height = lblH,
    };
    _m_licenceTypeLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_storeNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = lblW,
        .size.height = lblH,
    };
    _m_valideTimeStartLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_licenceTypeLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = lblW,
        .size.height = lblH,
    };
    _m_valideTimeEndLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_valideTimeStartLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = lblW,
        .size.height = lblH,
    };
    _m_requestDateLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_valideTimeEndLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = lblW,
        .size.height = lblH,
    };
    _m_rejectCauseLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_requestDateLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = lblW,
        .size.height = lblH,
    };
    
    _m_processLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_rejectCauseLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = 120,
        .size.height = lblH,
    };
    _m_processValueLabel.frame = (CGRect){
        .origin.x = _m_processLabel.right,
        .origin.y = _m_processLabel.y,
        .size.width = 120,
        .size.height = lblH,
    };
    _m_processFractionLabel.frame = (CGRect){
        .origin.x = SCREEN_SIZE.width - 80 - GTO_LEFT_PADDING  ,
        .origin.y = _m_processLabel.y,
        .size.width = 100,
        .size.height = lblH,
    };
    
    CGRect rect = (CGRect){
        .origin.x = _m_processLabel.x,
        .origin.y = _m_processLabel.bottom + GTO_VERTICAL_PADDING ,
        .size.width = SCREEN_SIZE.width - _m_processLabel.x - GTO_LEFT_PADDING,
        .size.height = 20,
    };
    self.m_processBarView = [[IBTUIView alloc]initWithFrame:rect processBarFloat:_d_processLength processBarColor:GTO_BLUE_SHALLOW_TINT_COLOR viewBorderBarColor:GTO_GRAY_SHALLOW_TINT_COLOR];
    [self addSubview:_m_processBarView];
    
    
}

@end

@implementation GTOLicenceResultTopCellContentView (configure)
- (void)updateWithLicence: (GTOLicence *)licence arrayDictDisplayResults: (NSArray *)arrDisplayResults
{
    self.m_billNumberLabel.text = [NSString stringWithFormat:@"报修单号：%@",licence.repairNumber ];
    self.m_riskGradeLabel.text = [NSString stringWithFormat:@"危险等级：%@",licence.riskGrade];
    self.m_storeNameLabel.text = [NSString stringWithFormat:@"油站：%@",licence.store_name ];
    self.m_licenceTypeLabel.text = [NSString stringWithFormat:@"许可证类型：%@",licence.licenceType];
    self.m_valideTimeStartLabel.text = [NSString stringWithFormat:@"申请时间：%@",licence.requestDate];
    NSDateFormatter *f = [[NSDateFormatter alloc] init];
    [f setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
    NSDate *date = [f dateFromString:licence.requestDate];
    NSDate *endDate = [NSDate dateWithTimeInterval:licence.validHours * 60 * 60 sinceDate:date];
    self.m_valideTimeEndLabel.text = [NSString stringWithFormat:@"截止时间：%@",[f stringFromDate:endDate]];
    self.m_rejectCauseLabel.text = [NSString stringWithFormat:@"拒绝理由：%@",licence.rejectCause];
    
    
    
    
    
    self.m_processLabel.text = [NSString stringWithFormat:@"拓站总进度：" ];
    NSUInteger totalNumber = arrDisplayResults.count;
    NSUInteger finishNumber = 0;
    for(NSDictionary *dictDisplayR in arrDisplayResults){
        GTODisplayResult *displayR = [GTODisplayResult DBObject];
        [displayR praseFromJsonDict:dictDisplayR];
        if (displayR.arrAnswers.count == displayR.arrQuestions.count) {
            finishNumber ++;
        }
    }
    self.d_processLength = 1.0 * finishNumber / totalNumber;
    int percent = self.d_processLength *100;
    self.m_processValueLabel.text = [NSString stringWithFormat:@"进行中 %d%%",percent];
    [self layoutSubviews];
}

@end
