//
//  SeePriceDetailsTableViewCell.m
//  total
//
//  Created by 曹云霄 on 16/6/21.
//  Copyright © 2016年 free. All rights reserved.
//

#import "SeePriceDetailsTableViewCell.h"
#import "SeePriceCollectionViewCell.h"
#import "SeePriceCollectionReusableView.h"

@implementation SeePriceDetailsTableViewCell


- (void)awakeFromNib {
    [super awakeFromNib];
    
    [self uiConfigAction];
}

- (NSMutableArray *)datasArray
{
    if (!_datasArray) {
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}

#pragma mark -赋值
- (void)setDatasResult:(QueryResult *)datasResult
{
    _datasResult = datasResult;
    NSArray *array = _datasResult.records;
    [self.datasArray removeAllObjects];
    for (NSDictionary *dict in array) {
        for (NSDictionary *dict2 in array) {
            if ([dict[@"item"][@"name"] isEqualToString:dict2[@"item"][@"name"]]) {
                if (([dict[@"category"] isEqualToString:@"salePrice"] && [dict2[@"category"] isEqualToString:@"generalTradePrice"]) || ([dict2[@"category"] isEqualToString:@"salePrice"] && [dict[@"category"] isEqualToString:@"generalTradePrice"])) {
                    NSString *name = [[dict objectForKey:@"item"] objectForKey:@"name"];
                    if ([self.datasArray containsObject:name]) {
                        break;
                    }
                    [self.datasArray addObject:name];
                    [self.datasArray addObject:[[dict objectForKey:@"guidancePrice"] stringValue]];
                    [self.datasArray addObject:[[dict2 objectForKey:@"salePrice"] stringValue]];break;
                }
            }
        }
    }
    [self.priceDetailsCollectionView reloadData];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.priceDetailsCollectionLayout.itemSize = CGSizeMake(((ScreenSize.width-16)/3), 40);
    self.priceDetailsCollectionLayout.minimumLineSpacing = 0;
    self.priceDetailsCollectionLayout.minimumInteritemSpacing = 0;
    self.priceDetailsCollectionView.dataSource = self;
    self.priceDetailsCollectionView.delegate = self;
    self.priceDetailsCollectionView.emptyDataSetSource = self;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    SeePriceCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"SeePriceCollectionViewCell" forIndexPath:indexPath];
    cell.priceDetailsLabe.text = [self.datasArray objectAtIndex:indexPath.row];
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.datasArray.count;
}


#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return KNODATAIMAGE;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    NSDictionary *attributes = @{NSFontAttributeName: [UIFont boldSystemFontOfSize:15.0f], NSForegroundColorAttributeName: [UIColor darkGrayColor]};
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:attributes];
}






@end
