//
//  GTOHomeItem.m
//  total
//
//  Created by freecui on 15/10/12.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOHomeItem.h"
@interface GTOHomeItem ()

@property(nonatomic, strong) IBTUILabel *contentLabel;


@end
@implementation GTOHomeItem

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self){
        return nil;
    }
 

    [self initSubViews];

    return self;

}
- (void)initSubViews {
    self.bgImgView = [[UIImageView alloc] init];
    self.bgImgView.contentMode = UIViewContentModeScaleToFill;
    self.bgImgView.userInteractionEnabled = YES;
    self.bgImgView.image = [UIImage imageNamed:@"home_item_bg_orange"];
    
    self.titleLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:18] tintColor:[UIColor blackColor] backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.lineView = [[UIView alloc] init];
    self.lineView.backgroundColor = GTO_GRAY_TINT_COLOR;
    self.contentLabel = [[IBTUILabel alloc] initWithfont:[UIFont systemFontOfSize:17]
                                               tintColor:GTO_GRAY_TINT_COLOR
                                         backgroundColor:nil
                                           textAlignment:NSTextAlignmentLeft];
    
    [self.bgImgView  addSubview:_titleLabel];
    [self.bgImgView  addSubview: _lineView];
    
    [self.bgImgView addSubview:_contentLabel];
    [self addSubview:_bgImgView];
}
- (void)layoutSubviews {
    [super layoutSubviews];
    self.bgImgView.frame = CGRectMake(10, 0,self.width - 2 * 10,self.height);
    self.titleLabel.frame = CGRectMake(LEFT_PADDING, 0, self.width * 0.6, 44);
    self.lineView.frame = CGRectMake(LEFT_PADDING, _titleLabel.bottom,self.bgImgView.width - 2 * LEFT_PADDING,1);
    self.contentLabel.frame = CGRectMake(LEFT_PADDING, _lineView.bottom + 0.5, self.bgImgView.width - 2 * LEFT_PADDING, _titleLabel.height);
    
}
@end

@implementation GTOHomeItem (configure)
- (void)updateWithInfoType: (infoType)infoType
                  newsNumber: (NSUInteger)number {
    NSString *titleStr = [NSString string];
    NSString *contentStr = [NSString string];
    switch (infoType) {
        case kAffiche:
        {
            titleStr = @"未读公告";
            if (number == 0) {
                contentStr = @"无最新消息";
            } else {
                contentStr = [NSString stringWithFormat:@"你有%ld条公告未读",number];
            }
        }
            break;
        case kLicence :
        {
            titleStr = @"许可证审批";
            if (number == 0) {
                contentStr = @"无未审批的许可证";
            } else {
                contentStr = [NSString stringWithFormat:@"你有%ld条未审批的许可证",number];
            }

        }
            break;
        case kProjectPatrol :
        {
            titleStr = @"工程VI检查";
            contentStr = @"无工程VI检查任务";
        }
            break;
        case kHSEPatrol:
        {
            titleStr = @"HSE专项VI检查";
            contentStr = @"无HSE专项VI检查任务";
        }
            break;

        default:
        {
            titleStr = @"无";
            contentStr = @"";
        }
            break;
    }
    
    self.titleLabel.text = titleStr;
    self.contentLabel.text = contentStr;
    [self layoutSubviews];
}
@end
