//
//  AccountConfigModel.h
//  Patrol
//
//  Created by 曹云霄 on 2017/8/10.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseModel.h"

@class AccountConfigModel_uploadType;
@class PublicConfigModel;
@class AccountConfigModel_repairFeeType;
@class AccountConfigModel_repairType;
@class AccountConfigModel_storeType;
@class AccountConfigModel_data;
@class CompanyLogoModel;


@protocol AccountConfigModel_uploadType @end
@protocol PublicConfigModel @end
@protocol AccountConfigModel_repairFeeType @end
@protocol AccountConfigModel_repairType @end
@protocol AccountConfigModel_storeType @end
@protocol AccountConfigModel_data @end
@protocol CompanyLogoModel @end



@interface AccountConfigModel : BaseModel

@property (nonatomic, strong)  NSString *message;

@property (nonatomic, strong)  NSArray <AccountConfigModel_data> *data;

@property (nonatomic, strong)  NSNumber *success;


//////////////////解析后配置项////////////////////
@property (nonatomic, strong) AccountConfigModel_uploadType *uploadType;
@property (nonatomic, strong) AccountConfigModel_repairFeeType *repairFeeType;
@property (nonatomic, strong) AccountConfigModel_repairType *repairType;
@property (nonatomic, strong) AccountConfigModel_storeType *storeType;
@property (nonatomic, strong) CompanyLogoModel *companyLogo;


/**
 VI检查单选题、多选题、是非题  自动答题
 */
@property (nonatomic, assign) BOOL automaticAnswer;
/**
 解析
 */
- (void)analysisConfigModel;

@end


/**
 账户配置项
 */
@interface AccountConfigModel_data : BaseModel

@property (nonatomic, strong)  NSString *optionKey;

@property (nonatomic, strong)  NSString *uuid;

@property (nonatomic, strong)  NSString *optionValue;

@property (nonatomic, strong)  NSString *enterprise;

@end



/**
 第三方上传(OSS,COS)
 */
@interface AccountConfigModel_uploadType : BaseModel

@property (nonatomic,copy) NSString *accessKey;

@property (nonatomic,copy) NSString *secretKey;

@property (nonatomic,copy) NSString *endPoint;

@property (nonatomic,copy) NSString *bucketName;

@property (nonatomic,copy) NSString *region;

@property (nonatomic,copy) NSString *imgEndpoint;

@property (nonatomic,copy) NSString *ossType;

@property (nonatomic,copy) NSString *width;

@property (nonatomic,copy) NSString *height;

@property (nonatomic,copy) NSString *imagePath;

@property (nonatomic,copy) NSString *videoPath;

@property (nonatomic,copy) NSString *appid;

@property (nonatomic,copy) NSString *type;


@end


/**
 保修费用类型
 */
@interface AccountConfigModel_repairFeeType : BaseModel

@property (nonatomic, strong) NSArray <PublicConfigModel> *repairFeeTypeArray;

@end


/**
 保修类型
 */
@interface AccountConfigModel_repairType : BaseModel

@property (nonatomic, strong) NSArray <PublicConfigModel> *repairTypeArray;

@end


/**
 门店类型
 */
@interface AccountConfigModel_storeType : BaseModel

@property (nonatomic, strong) NSArray <PublicConfigModel> *storeTypeArray;

@end



/**
 公告配置项
 */
@interface PublicConfigModel : BaseModel

@property (nonatomic, copy) NSString *value;

@property (nonatomic, copy) NSString *text;

@end


/**
 公司logo配置项
 */
@interface CompanyLogoModel : BaseModel

@property (nonatomic, copy) NSString *logourl;

@property (nonatomic, copy) NSString *mobile;

@end

/**
 地图类型配置项   value == googleMap || value == baiduMap
 */
@interface MapTypeModel : BaseModel

@property (nonatomic, copy) NSString *value;

@end


/**
 地图类型配置项   value == 是 || value == 否
 */
@interface AuthorityLockModel : BaseModel

@property (nonatomic, copy) NSString *value;

@end







