//
//  BaseModel.h
//  Patrol
//
//  Created by 曹云霄 on 2017/7/25.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "JSONModel.h"
#import <UIKit/UIKit.h>


@class InspectQuickLookQuery;
@protocol InspectQuickLookQuery @end

@interface BaseModel : JSONModel

/**
 *  排序条件
 */
@property (nonatomic,copy) NSArray <InspectQuickLookQuery>*queryOrders;

/**
 字典转模型
 
 @param dic 字典
 @return 转换之后的模型类
 */
+ (instancetype)modelWithDic:(NSDictionary *)dic;

/**
 模型转模型
 
 @param model 要转换的模型类
 @return 转换之后的模型类
 */
- (instancetype)modelWithModel:(id)model;
@end


//排序字段
@interface InspectQuickLookQuery : BaseModel

@property (nonatomic, strong) NSString *field;
@property (nonatomic, assign) NSString *direction;

@end
