//
//  BaseNavigationViewController.m
//  Patrol
//
//  Created by 曹云霄 on 2017/7/20.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "BaseNavigationViewController.h"

@interface BaseNavigationViewController ()<UINavigationControllerDelegate>

@end

@implementation BaseNavigationViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self configAction];
}

- (void)configAction
{
    self.delegate = self;
    [[UIApplication sharedApplication] setStatusBarStyle:UIStatusBarStyleLightContent animated:NO];
    [[UIApplication sharedApplication] setStatusBarHidden:NO];
}

#pragma mark -重写push方法
- (void)pushViewController:(UIViewController *)viewController animated:(BOOL)animated
{
    if (self.viewControllers.count > 0) {
        viewController.hidesBottomBarWhenPushed = YES;
        viewController.navigationItem.hidesBackButton = YES;
        UIButton *leftBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        leftBtn.frame = CGRectMake(0, 0, 40, 40);
        [leftBtn setImage:TCImage(@"result_back_icon") forState:UIControlStateNormal];
        leftBtn.imageEdgeInsets = UIEdgeInsetsMake(0, -20, 0, 0);
        [leftBtn addTarget:self action:@selector(backBarButtonItemClick) forControlEvents:UIControlEventTouchUpInside];
        viewController.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:leftBtn];
    }
    [super pushViewController:viewController animated:animated];
}

#pragma mark -返回
- (void)backBarButtonItemClick
{
    if (self.backClickAction) {
        self.backClickAction();
        self.backClickAction = nil;
    }else {
        [self popViewControllerAnimated:YES];
    }
}

@end
