//
//  BasePullCollectionViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/7/12.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "BasePullCollectionViewController.h"
#import "MjRefreshHeaderCustom.h"

@interface BasePullCollectionViewController ()

@end

@implementation BasePullCollectionViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupcollectionView];
    [self setupcollectionViewAdditional];
}

#pragma mark -初始化设置

- (void)setupcollectionView
{
    if (@available(iOS 11.0, *)) {
        self.collectionView.contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentNever;
    } else {
        self.automaticallyAdjustsScrollViewInsets = NO;
    }
    self.collectionView.delegate = self;
    self.collectionView.dataSource = self;
    self.collectionView.alwaysBounceVertical = YES;
    self.pullPageIndex = ZERO;
}

#pragma mark - 添加上、下拉刷新

-(void)setupcollectionViewAdditional
{
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingTarget:self refreshingAction:@selector(loadCollectionViewHeader)];
    headerRefresh.mj_size = CGSizeMake(40, 40);
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    headerRefresh.stateLabel.hidden = YES;
    self.collectionView.mj_header = headerRefresh;
    [self.collectionView.mj_header beginRefreshing];
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingTarget:self refreshingAction:@selector(loadCollectionViewFooter)];
    footer.automaticallyHidden = YES;
    [footer setTitle:@"~ end ~" forState:MJRefreshStateNoMoreData];
    [footer setTitle:@"加载更多" forState:MJRefreshStateIdle];
    [footer setTitle:@"加载中..." forState:MJRefreshStateRefreshing];
    footer.stateLabel.textColor = ICR_TINTCOLOR;
    self.collectionView.mj_footer = footer;
}

#pragma mark - 设置无数据代理
- (void)setupNotDataDelegate
{
    self.collectionView.emptyDataSetSource = self;
    self.collectionView.emptyDataSetDelegate = self;
}

#pragma mark -刷新回调

-(void)loadCollectionViewHeader
{
    [self.collectionView.mj_footer resetNoMoreData];
    [self setupNotDataDelegate];
    self.pullPageIndex = ZERO;
    [self loadWebDataSource];
}

-(void)loadCollectionViewFooter
{
    [self setupNotDataDelegate];
    self.pullPageIndex ++;
    [self loadWebDataSource];
}

#pragma mark -结束刷新

- (void)endRefresh:(EndRefreshType)type
{
    if (self.collectionView.mj_header.isRefreshing) {
        [self.collectionView.mj_header endRefreshing];
    }
    if (self.collectionView.mj_footer.isRefreshing) {
        [self.collectionView.mj_footer endRefreshing];
    }
    if (type == EndRefreshNotData) {
        [self.collectionView.mj_footer endRefreshingWithNoMoreData];
    }
}

#pragma mark -加载数据 (需重写)

-(void)loadWebDataSource
{
    if (self.collectionView.isEmptyDataSetVisible) {
        [self.collectionView reloadEmptyDataSet];
    }
}

#pragma mark -UICollectionViewDelegate,UICollectionViewDataSource

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return ONE;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return [UICollectionViewCell new];
}


#pragma mark - DZNEmptyDataSetSource Methods

- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return TCImage(@"not_data");
}

- (NSAttributedString *)descriptionForEmptyDataSet:(UIScrollView *)scrollView
{
    NSDictionary *dic = @{NSFontAttributeName:[UIFont systemFontOfSize:15],NSForegroundColorAttributeName:[UIColor grayColor]};
    NSAttributedString *attr = [[NSAttributedString alloc] initWithString:@"对不起,居然真的没有数据" attributes:dic];
    return attr;
}


#pragma mark - DZNEmptyDataSetDelegate Methods

- (BOOL)emptyDataSetShouldShow:(UIScrollView *)scrollView
{
    return YES;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}


@end
