//
//  BasePullTableViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/7/12.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "BasePullTableViewController.h"
#import "MjRefreshHeaderCustom.h"
@interface BasePullTableViewController ()

@end

@implementation BasePullTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupTableView];
    [self setupTableViewAdditional];
}

#pragma mark -初始化设置

- (void)setupTableView
{
    if (@available(iOS 11.0, *)) {
        self.tableView.contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentNever;
    } else {
        self.automaticallyAdjustsScrollViewInsets = NO;
    }
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.tableFooterView = [UIView new];
    self.pullPageIndex = ZERO;
}
#pragma mark - 添加上、下拉刷新
-(void)setupTableViewAdditional
{
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingTarget:self refreshingAction:@selector(loadTableViewHeader)];
    headerRefresh.mj_size = CGSizeMake(40, 40);
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    headerRefresh.stateLabel.hidden = YES;
    self.tableView.mj_header = headerRefresh;
    [self.tableView.mj_header beginRefreshing];
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingTarget:self refreshingAction:@selector(loadTableViewFooter)];
    footer.automaticallyHidden = YES;
    [footer setTitle:@"加载更多" forState:MJRefreshStateIdle];
    [footer setTitle:@"加载中..." forState:MJRefreshStateRefreshing];
    [footer setTitle:@"~ end ~" forState:MJRefreshStateNoMoreData];
    footer.stateLabel.textColor = ICR_TINTCOLOR;
    self.tableView.mj_footer = footer;
}

#pragma mark - 设置无数据代理
- (void)setupNotDataDelegate
{
    self.tableView.emptyDataSetSource = self;
    self.tableView.emptyDataSetDelegate = self;
}

#pragma mark -刷新回调

-(void)loadTableViewHeader
{
    [self.tableView.mj_footer resetNoMoreData];
    [self setupNotDataDelegate];
    self.pullPageIndex = ZERO;
    [self loadWebDataSource];
}

-(void)loadTableViewFooter
{
    [self setupNotDataDelegate];
    self.pullPageIndex ++;
    [self loadWebDataSource];
}

#pragma mark -结束刷新

- (void)endRefresh:(EndRefreshType)type
{
    if (self.tableView.mj_header.isRefreshing) {
        [self.tableView.mj_header endRefreshing];
    }
    if (self.tableView.mj_footer.isRefreshing) {
        [self.tableView.mj_footer endRefreshing];
    }
    if (type == EndRefreshNotData) {
        [self.tableView.mj_footer endRefreshingWithNoMoreData];
    }
}

#pragma mark -加载数据 (需重写)

-(void)loadWebDataSource
{
    if (self.tableView.isEmptyDataSetVisible) {
        [self.tableView reloadEmptyDataSet];
    }
}

#pragma mark -UITableViewDelegate,UITableViewDataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return ONE;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [UITableViewCell new];
}

#pragma mark - DZNEmptyDataSetSource Methods

- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return TCImage(@"not_data");
}

- (NSAttributedString *)descriptionForEmptyDataSet:(UIScrollView *)scrollView
{
    NSDictionary *dic = @{NSFontAttributeName:[UIFont systemFontOfSize:15],NSForegroundColorAttributeName:[UIColor grayColor]};
    NSAttributedString *attr = [[NSAttributedString alloc] initWithString:@"对不起,居然真的没有数据" attributes:dic];
    return attr;
}

#pragma mark - DZNEmptyDataSetDelegate Methods

- (BOOL)emptyDataSetShouldShow:(UIScrollView *)scrollView
{
    return YES;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}


@end
