//
//  BaseViewModel.h
//  Patrol
//
//  Created by 曹云霄 on 2017/7/20.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NetWorkRequestManager.h"
@interface BaseViewModel : NSObject

@property (strong, nonatomic) SuccessBlock returnBlock;
@property (strong, nonatomic) ErrorBlock failureBlock;

/**
 网络请求类型
 
 - POST:  POST请求
 - GET:   GET请求
 */
typedef NS_ENUM(NSInteger,HTTP_TYPE){
    POST,
    GET
};

/**
 传递数据

 @param successBlock  成功回调
 @param failureBlock  失败回调
 */
- (void)setBlock:(SuccessBlock)successBlock failureBlock:(ErrorBlock)failureBlock;


/**
 基类网络请求

 @param urlString     请求地址
 @param type          HTTP类型
 @param parmeter      参数
 @param successBlock  成功回调
 @param failureBlock  失败回调
 */
- (void)HTTPRequest:(NSString *)urlString type:(HTTP_TYPE)type parmeter:(NSDictionary *)parmeter successBlock:(SuccessBlock)successBlock failureBlock:(ErrorBlock)failureBlock;

/**
 获取服务器时间

 @param success 服务器时间
 */
- (void)getSystemTime:(SuccessBlock)success;

/**
 校验数据
 用户网络请求返回
 @param object 返回数据
 */
+ (BOOL)verifyData:(id)object;

/**
 取出data数据

 @param object 返回数据
 @return       data
 */
+ (NSDictionary *)formatData:(id)object;

/**
 错误信息

 @param object 返回数据
 @return       message
 */
+ (NSString *)messageData:(id)object;




















@end
