//
//  DateTextField.m
//  RealEstateManagement
//
//  Created by Javen on 2016/11/8.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "DateTextField.h"

@interface DateTextField () <UITextFieldDelegate>
@property (strong, nonatomic) UIDatePicker *datePicker;
@end

@implementation DateTextField
- (void)awakeFromNib {
  [super awakeFromNib];
  self.delegate = self;
  //如果没有设置时间范围，则默认可选取的最大时间是当前时间
  if (!self.maxDate && !self.minDate) {
    self.datePicker.maximumDate = [NSDate date];
  }else{
    self.datePicker.maximumDate = self.maxDate;
    self.datePicker.minimumDate = self.minDate;
  }
    [self.datePicker addTarget:self action:@selector(actionPickerDidChanged:) forControlEvents:UIControlEventValueChanged];
}

- (void)setType:(DateTextFieldType)type {
    _type = type;
    UIDatePicker *datePicker = self.datePicker;
    NSDate *date = datePicker.date;
    switch (self.type) {
        case DateTextFieldYearMonth: {
            self.text = [date yearMonthString];
            datePicker.datePickerMode = UIDatePickerModeDate;
            break;
        }
        case DateTextFieldYearMonthDay: {
            self.text = [date yearMonthDayString];
            datePicker.datePickerMode = UIDatePickerModeDate;
            break;
        }
        case DateTextFieldTime: {
            datePicker.datePickerMode = UIDatePickerModeDateAndTime;
            self.text = [date httpParameterString];
            break;
        }
    }
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField {
    if (self.blockBeginEdit) {
        self.blockBeginEdit();
    }
    return YES;
}

- (void)textFieldDidBeginEditing:(UITextField *)textField {
    if (self.rangeType == DateTextFieldRangeAfter) {
        self.datePicker.minimumDate = [NSDate date];
        self.datePicker.maximumDate = nil;
    }else if (self.rangeType == DateTextFieldRangeBefore){
        self.datePicker.minimumDate = nil;
        self.datePicker.maximumDate = [NSDate date];
    }else{
        self.datePicker.minimumDate = nil;
        self.datePicker.maximumDate = nil;
    }
}


- (void)textFieldDidEndEditing:(UITextField *)textField
{
    if (self.blockEndEdit) {
        self.blockEndEdit();
    }
}

- (void)actionPickerDidChanged:(UIDatePicker *)datePicker
{
    NSDate *date = datePicker.date;
    switch (self.type) {
        case DateTextFieldYearMonth: {
            self.text = [date yearMonthString];
            break;
        }
        case DateTextFieldYearMonthDay: {
            self.text = [date yearMonthDayString];
            break;
        }
        case DateTextFieldTime: {
            self.text = [date httpParameterString];
            break;
        }
    }
}

- (BOOL)canPerformAction:(SEL)action withSender:(id)sender
{
    if (action == @selector(paste:))//禁止粘贴
        return NO;
    if (action == @selector(select:))// 禁止选择
        return NO;
    if (action == @selector(selectAll:))// 禁止全选
        return NO;
    return [super canPerformAction:action withSender:sender];
}

- (void)setMaxDate:(NSDate *)maxDate {
  _maxDate = maxDate;
  self.datePicker.maximumDate = maxDate;
}

- (void)setMinDate:(NSDate *)minDate {
  _minDate = minDate;
  self.datePicker.minimumDate = minDate;
}

- (NSDate *)date {
    return self.datePicker.date;
}

- (UIDatePicker *)datePicker {
    if (!_datePicker) {
        _datePicker = [[UIDatePicker alloc] initWithFrame:CGRectMake(0, 0, ScreenSize.width, 216)];
        self.inputView = _datePicker;
        NSDate *date = [NSDate date];
        _datePicker.date = date;
    }
    return _datePicker;
}

@end
