//
//  GTOTemplateNameViewController.m
//  total
//
//  Created by freecui on 15/10/14.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOPioneeringTemplateViewController.h"
#import "GTOPatrolTemplate.h"
#define TopMargin 50
#define TableHeight 50
@interface GTOPioneeringTemplateViewController ()

@end

@implementation GTOPioneeringTemplateViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    //记录更新时间
    self.tableView.header.lastUpdatedTimeKey = TemplateNameUpdateDate;
    self.title = @"选择许可证类型";
    [self fetchDataList:@"" tableStr:GTO_PATROL_TEMPLATE];
}
- (void)getBaseDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            __strong __typeof(weakSelf)strongSelf = weakSelf;
            [strongSelf endRefreshing];
            [self fetchDataList:@"" tableStr:GTO_PATROL_TEMPLATE];
        }else{
            [IBTLoadingView showTips:data];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getPatrolTemplateWithPurpose:_purpose pageNumber:0 pageSize:20 success:succ failure:fail];
}
#pragma mark - 协议方法
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:SEARCH_TABLECELL_HEIGHT];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (self.isMoreChose) {
        if ([self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
            cell.titleLabel.textColor = BASESELECT_COLOR;
            
        }else{
            cell.Commitbtn.hidden = YES;
            cell.titleLabel.textColor = [UIColor blackColor];
            
        }
    }else{
        if (self.currentIndexPath) {
            if (indexPath.row == self.currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
                cell.titleLabel.textColor = BASESELECT_COLOR;
                
            }else{
                cell.Commitbtn.hidden = YES;
                cell.titleLabel.textColor = [UIColor blackColor];
                
            }
        }else{
            cell.Commitbtn.hidden = YES;
            cell.titleLabel.textColor = [UIColor blackColor];
            
        }
    }
    if (self.dataArr.count > 0) {
        if (indexPath.row == 0) {
            NSString *dateStr = [self.dataArr[indexPath.row] httpParameterString];
            cell.titleLabel.textColor = GXF_CONTENT_COLOR;
            [cell setTitleStr:[NSString stringWithFormat:@"上次更新时间:%@",dateStr]];
        }else{
//            Vendor *vendor =  self.dataArr[indexPath.row];
//            NSString *proStr = [NSString stringWithFormat:@"%@[%@]",vendor.name,vendor.code];
            GTOPatrolTemplate *patrolTemplate = self.dataArr[indexPath.row];
            NSString *pTemName = [NSString stringWithFormat:@"%@",patrolTemplate.name];
            [cell setTitleStr:pTemName];
        }
    }
    return cell;
}


//筛选
- (void)boxValueChanged:(NSNotification *)fication{
    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
    [self fetchDataList:tilkeStr tableStr:GTO_PATROL_TEMPLATE];
}

- (void)tableViewRefresh:(NSString *)titltstr{
    if (titltstr.length > 0) {
        [super tableViewRefresh:titltstr];
    }else{
        if (self.selectStr.length>0) {
            if (!self.isMoreChose) {
                for (NSInteger i = 1;i< self.dataArr.count; i++) {
                   GTOPatrolTemplate *patrolTemplate = self.dataArr[i];
                    if ([patrolTemplate.uuid isEqualToString:self.selectStr]) {
                        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:i inSection:0];
                        self.currentIndexPath = indexPath;
                        break;
                    }
                }
                [self.tableView reloadData];
            }
        }else{
            [super tableViewRefresh:titltstr];
        }
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
