//
//  CustomSelectCityViewController.m
//  total
//
//  Created by 曹云霄 on 16/6/28.
//  Copyright © 2016年 Delevin. All rights reserved.
//

#import "CustomSelectCityViewController.h"

@interface CustomSelectCityViewController ()<UIPickerViewDelegate,UIPickerViewDataSource>

/**
 *  省(总)
 */
@property (nonatomic,strong) NSMutableArray *provinceArray;

/**
 *  市(总)
 */
@property (nonatomic,strong) NSMutableArray *cityArray;

/**
 *  省对应的城市
 */
@property (nonatomic,strong) NSArray *selectCityArray;

/**
 *  选择的省
 */
@property (nonatomic,copy) NSDictionary *provinceDict;

/**
 *  选择的市
 */
@property (nonatomic,strong) NSDictionary *cityDict;

@end

@implementation CustomSelectCityViewController

- (NSMutableArray *)provinceArray
{
    if (!_provinceArray) {
        _provinceArray = [NSMutableArray array];
    }
    return _provinceArray;
}

- (NSMutableArray *)cityArray
{
    if (!_cityArray) {
        _cityArray = [NSMutableArray array];
    }
    return _cityArray;
}

#pragma mark -解析数据(省、城市)
- (void)setDatasArray:(NSArray *)datasArray
{
    _datasArray = datasArray;
    for (NSArray *arr in _datasArray) {
        [self.provinceArray addObject:[arr firstObject]];
        NSMutableArray *tempArray = [arr mutableCopy];
        [tempArray removeObjectAtIndex:0];
        [self.cityArray addObject:tempArray];
    }
    self.selectCityArray = [self.cityArray objectAtIndex:0];
    self.provinceDict = [self.provinceArray objectAtIndex:0];
    [self.customDateSelectPickerView reloadAllComponents];
}


- (void)viewDidLoad {
    [super viewDidLoad];

    self.customDateSelectPickerView.dataSource = self;
    self.customDateSelectPickerView.delegate = self;
}


#pragma mark -城市选择器代理方法
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 2;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)componen
{
    switch (componen) {
        case 0:
        {
            return [self.provinceArray count];
        }
            break;
        case 1:
        {
            return [self.selectCityArray count];
        }
            break;

            
        default:
            break;
    }
    return 0;
}


- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    switch (component)
    {
        case 0:
            return [[self.provinceArray objectAtIndex:row] objectForKey:@"name"];
            break;
        case 1:
            return [[self.selectCityArray objectAtIndex:row] objectForKey:@"name"];
            break;

        default:
            return nil;
            break;
    }
}


- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    switch (component)
    {
        case 0:
            self.selectCityArray  = [self.cityArray objectAtIndex:row];
            [self.customDateSelectPickerView selectRow:0 inComponent:1 animated:NO];
            [self.customDateSelectPickerView reloadComponent:1];
            //选择省后回传
            self.provinceDict = [self.provinceArray objectAtIndex:row];
            self.cityDict = [self.selectCityArray objectAtIndex:0];
            break;
        case 1:
            //选择市后回传
            self.cityDict = [self.selectCityArray objectAtIndex:row];
            break;

        default:
            break;
    }
    
    if (self.completeSelectCityBlock) {
        self.completeSelectCityBlock([NSArray arrayWithObjects:self.provinceDict,self.cityDict,nil]);
    }
}


- (UIView *)pickerView:(UIPickerView *)pickerView viewForRow:(NSInteger)row forComponent:(NSInteger)component reusingView:(UIView *)view{
    UILabel* pickerLabel = (UILabel*)view;
    if (!pickerLabel){
        pickerLabel = [[UILabel alloc] init];
        pickerLabel.adjustsFontSizeToFitWidth = YES;
        pickerLabel.textAlignment = NSTextAlignmentCenter;
        [pickerLabel setBackgroundColor:[UIColor clearColor]];
        [pickerLabel setFont:[UIFont boldSystemFontOfSize:15]];
    }
    // Fill the label text here
    pickerLabel.text=[self pickerView:pickerView titleForRow:row forComponent:component];
    return pickerLabel;
}

@end
