//
//  FilterTimeChooseTableViewCell.m
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "FilterTimeChooseTableViewCell.h"

@implementation FilterTimeChooseTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];

    self.beginSubject = [RACSubject subject];
    self.endSubject = [RACSubject subject];
    self.begainDateTitleLabel.text = @"起始时间";
    self.endDateTitleLabel.text = @"截止时间";
}


/**
 已选择时间 > 默认时间
 
 @param beginDate  已选择开始时间
 @param endDate    已选择结束时间
 */
- (void)defaultDate:(NSString *)beginDate endDate:(NSString *)endDate
{
    if (![ToolsManager empty:beginDate]) {
        self.begainDateLabel.text = beginDate;
    }
    if (![ToolsManager empty:endDate]) {
        self.endDateLabel.text = endDate;
    }
}

#pragma mark -开始时间
- (IBAction)beginButtonClickAction:(UIButton *)sender {
    [[YXPickerManager shareManager] showDatePickerView:GTO_BLUE_DEEP_COLOR datePickerModel:UIDatePickerModeDate minimumDate:nil maximumDate:[NSDate dateWithString:self.endDateLabel.text format:@"yyyy-MM-dd"] defaultDate:[NSString stringWithFormat:@"%@ 00:00:00",self.begainDateLabel.text] commitBlock:^(NSString *date) {
        NSArray *dateArray = [date componentsSeparatedByString:@" "];
        self.begainDateLabel.text = dateArray[0];
        [self.beginSubject sendNext:self.begainDateLabel.text];
    } cancelBlock:^{
        NSLog(@"取消");
    }];
}

#pragma mark -截止时间
- (IBAction)endButtonClickAction:(UIButton *)sender {
    [[YXPickerManager shareManager] showDatePickerView:GTO_BLUE_DEEP_COLOR datePickerModel:UIDatePickerModeDate minimumDate:[NSDate dateWithString:self.begainDateLabel.text format:@"yyyy-MM-dd"] maximumDate:nil defaultDate:[NSString stringWithFormat:@"%@ 00:00:00",self.endDateLabel.text] commitBlock:^(NSString *date) {
        NSArray *dateArray = [date componentsSeparatedByString:@" "];
        self.endDateLabel.text = dateArray[0];
        [self.endSubject sendNext:self.endDateLabel.text];
    } cancelBlock:^{
        NSLog(@"取消");
    }];
}




@end
