//
//  FilterConfig.h
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FilterModel : BaseModel

/**
 筛选项名称
 */
@property (nonatomic, copy) NSString *name;

/**
 筛选项值
 */
@property (nonatomic, copy) NSString *value;

/**
 筛选项id（可选）
 */
@property (nonatomic, copy) NSString *uuid;

/**
 筛选项类型
 */
@property (nonatomic, assign) FILTER_TYPE type;

@end


@interface FilterConfig : NSObject

/**
 通过类名区分筛选条件

 @param name 类名
 @return     可使用的筛选条件
 */
+ (NSArray *)filterItemByClassName:(NSString *)name;

@end
