//
//  FilterDetailViewController.m
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "FilterDetailViewController.h"
#import "FilterDetailSearchTableViewCell.h"
@interface FilterDetailViewController ()<UITableViewDelegate,UITableViewDataSource,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>

/**
 *  显示数据
 */
@property (nonatomic,strong) NSArray *displayArray;


/**
 选中项  NSIndexPath
 */
@property (nonatomic, strong) NSIndexPath *selectedIndexPath;

@end

@implementation FilterDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTableView];
    [self addSureBarButton];
}

#pragma mark -设置TableView
- (void)setUpTableView
{
    self.filterDetailTableView.estimatedRowHeight = 50;
    self.filterDetailTableView.rowHeight = UITableViewAutomaticDimension;
    self.filterDetailTableView.tableFooterView = [UIView new];
    self.filterSearchBar.placeholder = @"请输入关键字";
    self.filterSearchBar.barTintColor = self.isContentVc ? [UIColor whiteColor] : GTO_BLUE_DEEP_COLOR;
    self.filterSearchBar.searchBarStyle = self.isContentVc ? UISearchBarStyleMinimal :UISearchBarStyleDefault;
    self.title = @"筛选项选择";
}

#pragma mark -添加确认按钮
- (void)addSureBarButton
{
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"确定" style:UIBarButtonItemStyleDone target:self action:@selector(sureAction)];
    self.navigationItem.rightBarButtonItem.enabled = NO;
}

#pragma mark -确认
- (void)sureAction
{
    [self popViewControllerAnimated:YES];
    if (self.sureButtonBlock) {
        FilterSearchModel *model = self.filterArray[self.selectedIndexPath.row];
        self.sureButtonBlock(self.selectedIndexPath, model,self.conditionIndexPath);
    }
}

#pragma mark -lazy
- (void)setFilterArray:(NSArray<FilterSearchModel *> *)filterArray
{
    _filterArray = filterArray;
    self.displayArray = [NSArray arrayWithArray:self.filterArray];
    [self.filterDetailTableView reloadData];
}

#pragma mark - searchbar delegate
- (BOOL)searchBarShouldBeginEditing:(UISearchBar *)searchBar {
    return YES;
}

- (void)searchBarCancelButtonClicked:(UISearchBar *)searchBar {
    searchBar.text = nil;
    [[UIApplication sharedApplication].keyWindow endEditing:YES];
    self.displayArray = [NSArray arrayWithArray:self.filterArray];
    [self.filterDetailTableView reloadData];
}

- (void)searchBar:(UISearchBar *)searchBar textDidChange:(NSString *)searchText {
    NSPredicate *pred = [NSPredicate predicateWithFormat:@"name contains [cd] %@ OR uuid contains [cd] %@", searchText, searchText];
    self.displayArray = [self.filterArray filteredArrayUsingPredicate:pred];
    if (searchText.length < 1) {
        self.displayArray = [NSArray arrayWithArray:self.filterArray];
    }
    [self.filterDetailTableView reloadData];
}

#pragma mark - tableview
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    FilterDetailSearchTableViewCell *searchCell = [tableView dequeueReusableCellWithIdentifier:[FilterDetailSearchTableViewCell className] forIndexPath:indexPath];
    FilterSearchModel *model = [self.displayArray yx_objectAtIndex:indexPath.row];
    searchCell.searchTitleLabel.text = model.name;
    searchCell.accessoryType = model.isSelected ? UITableViewCellAccessoryCheckmark : UITableViewCellAccessoryNone;
    return searchCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.displayArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0.01;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0.01;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    FilterSearchModel *currentModel = [self.displayArray yx_objectAtIndex:indexPath.row];
    for (FilterSearchModel *model in self.displayArray) {
        if (![model isEqual:currentModel]) {
            model.isSelected = NO;
        }
    }
    for (FilterDetailSearchTableViewCell *cell in tableView.visibleCells) {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    currentModel.isSelected = !currentModel.isSelected;
    NSIndexPath *realIndexPath = [NSIndexPath indexPathForRow:[self.filterArray indexOfObject:currentModel] inSection:ZERO];
    self.selectedIndexPath = realIndexPath;
    [tableView reloadRowAtIndexPath:indexPath withRowAnimation:UITableViewRowAnimationFade];
    self.navigationItem.rightBarButtonItem.enabled = YES;
    if (self.selectedItemBlock) {
        self.selectedItemBlock(realIndexPath, currentModel);
    }
}

#pragma mark - DZNEmptyDataSetSource Methods
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return TCImage(@"not_data");
}

- (NSAttributedString *)descriptionForEmptyDataSet:(UIScrollView *)scrollView
{
    NSDictionary *dic = @{NSFontAttributeName:[UIFont systemFontOfSize:15],NSForegroundColorAttributeName:[UIColor grayColor]};
    NSAttributedString *attr = [[NSAttributedString alloc] initWithString:@"对不起,居然真的没有数据" attributes:dic];
    return attr;
}

#pragma mark - DZNEmptyDataSetDelegate Methods
- (BOOL)emptyDataSetShouldShow:(UIScrollView *)scrollView
{
    return YES;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

@end
