//
//  FilterInputTableViewController.m
//  Patrol
//
//  Created by 曹云霄 on 2017/8/24.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "FilterInputTableViewController.h"

@interface FilterInputTableViewController ()<UITextViewDelegate>

@end

@implementation FilterInputTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self addSureBarButton];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.filterInputTextView.m_placeHolder = @"请输入";
    self.filterInputTextView.text = self.inputModel.name;
}

#pragma mark -添加确认按钮
- (void)addSureBarButton
{
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"确认" style:UIBarButtonItemStyleDone target:self action:@selector(sureAction)];
    self.navigationItem.rightBarButtonItem.enabled = NO;
}

#pragma mark -确认
- (void)sureAction
{
    [self popViewControllerAnimated:YES];
    if (self.sureButtonBlock) {
        self.sureButtonBlock(self.filterInputTextView.text,self.inputModel,self.conditionIndexPath);
    }
}

#pragma mark -<UITextViewDelegate>
- (void)textViewDidChange:(UITextView *)textView
{
    self.inputModel.name = textView.text;
    self.inputModel.uuid = textView.text;
    self.inputModel.isSelected = YES;
    BOOL boolValue = [ToolsManager empty:textView.text];
    self.navigationItem.rightBarButtonItem.enabled = !boolValue;
}

#pragma mark -<UITableViewDelegate,UITableDataSource>
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 10;
}





















@end
