//
//  FilterManager.h
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FilterConfig.h"
#import "FilterListViewController.h"



@interface FilterManager : NSObject

/**
 初始化筛选

 @param controller  筛选调用类
 @param queryModel  默认查询对象
 */
- (instancetype)initWithClass:(UIViewController *)controller queryModel:(BaseModel *)queryModel;

/**
 筛选ViewModel（保存选中条件）
 */
@property (nonatomic, strong) FilterViewModel *filterViewModel;

/**
 筛选控制器
 */
@property (nonatomic, strong) FilterListViewController *filterListVc;

/**
 筛选完成回调
 */
@property (nonatomic, copy) SuccessBlock completedBlock;


@end
