//
//  FilterManager.m
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "FilterManager.h"

@implementation FilterManager

- (instancetype)initWithClass:(UIViewController *)controller queryModel:(BaseModel *)queryModel
{
    if (self = [super init]) {
        [self mateFilterItemByClassName:controller queryModel:queryModel];
    }
    return self;
}

#pragma mark -通过类名匹配不同的筛选条件 -> 展示
- (void)mateFilterItemByClassName:(UIViewController *)controller queryModel:(BaseModel *)queryModel
{
    NSString *className = NSStringFromClass([controller class]);
    NSArray *filterArray = [FilterConfig filterItemByClassName:className];
    self.filterListVc.title = [NSString stringWithFormat:@"%@%@",controller.title,@"筛选"];
    self.filterListVc.filterViewModel.classVc = controller;
    self.filterListVc.filterViewModel.queryModel = queryModel;
    //回传选中筛选项
    if (self.filterViewModel) {
        self.filterListVc.filterViewModel = self.filterViewModel;
    }else {
    //初始化筛选项
        self.filterListVc.filterViewModel.classVc = controller;
        self.filterListVc.filterViewModel.conditionIndexPathArray = filterArray[1];
        self.filterListVc.filterViewModel.fileterArray = filterArray[0];
    }
    //筛选完成回调
    self.filterListVc.subject = [RACSubject subject];
    @weakify(self);
    @weakify(controller);
    [self.filterListVc.subject subscribeNext:^(FilterViewModel *selectedViewModel) {
        @strongify(self);
        @strongify(controller);
        if (self.completedBlock) {
            self.completedBlock(selectedViewModel);
        }
        [controller popViewControllerAnimated:YES];
    }];
}

#pragma mark -lazy
- (FilterListViewController *)filterListVc
{
    if (!_filterListVc) {
        _filterListVc = [FilterListViewController viewControllerWithStoryBoardType:STORYBOARD_TYPE_FILTER];
    }
    return _filterListVc;
}

@end
