//
//  FilterViewModel.h
//  Patrol
//
//  Created by 曹云霄 on 2017/8/15.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "BaseViewModel.h"
#import "FilterConfig.h"
#import "FilterSearchModel.h"

@interface FilterViewModel : BaseViewModel

/**
 需要筛选的类
 */
@property (nonatomic, strong) UIViewController *classVc;

/**
 筛选条件
 */
@property (nonatomic, strong) NSArray <FilterModel *> *fileterArray;

/**
 筛选条件详情选中后保存下标
 */
@property (nonatomic, strong) NSMutableArray *conditionIndexPathArray;

/**
 选择筛选条件对应下标
 */
@property (nonatomic, strong) NSIndexPath *indexPath;

/**
 筛选tableview
 */
@property (nonatomic, strong) UITableView *tableView;

/**
 筛选完成后通过不同的类生成对应的查询model
 */
@property (nonatomic, strong) BaseModel *queryModel;

/**
 供使用的查询模型
 */
@property (nonatomic,strong) BaseModel *useQueryModel;

/***********UI*************/


/**
 筛选条件cell

 @param indexPath NSIndexPath
 @return          UITableViewCell
 */
- (UITableViewCell *)conditionItemCell:(NSIndexPath *)indexPath tableView:(UITableView *)tableView;

/**
 点击某一个筛选条件（判断是否需要请求网络或者从本地加载）

 @param indexPath NSIndexPath
 @param success   SuccessBlock
 */
- (void)gotoConditionDetailVc:(NSIndexPath *)indexPath success:(SuccessBlock)success;

/**
 点击一个筛选条件（输入）
 
 @param success   SuccessBlock
 */
- (void)gotoInputDetailVc:(NSIndexPath *)indexPath success:(SuccessBlock)success;
/**
 更新选择后的筛选条件

 @param indexPath               本地筛选NSIndexPath
 @param conditionIndexPath      筛选条件NSIndexPath
 @param conditionModel          自定义FilterSearchModel（本地搜索界面使用）
 */
- (void)updateSomeCondition:(NSIndexPath *)indexPath conditionModel:(FilterSearchModel *)conditionModel conditionIndexPath:(NSIndexPath *)conditionIndexPath tableView:(UITableView *)tableView;

/**
 更新输入后的筛选条件
 
 @param conditionIndexPath      筛选条件NSIndexPath
 @param conditionModel          自定义FilterSearchModel（本地搜索界面使用）
 */
- (void)updateInputConditionModel:(FilterSearchModel *)conditionModel conditionIndexPath:(NSIndexPath *)conditionIndexPath tableView:(UITableView *)tableView;

/**
 确认筛选条件
 */
- (void)sureFilterCondition;

/**
 重置筛选条件
 */
- (void)resetFilterCondition;


@end
