//
//  BaiduLocationManager.h
//  patrol
//
//  Created by 曹云霄 on 2016/10/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <BaiduMapAPI_Location/BMKLocationComponent.h>
#import <BaiduMapAPI_Search/BMKSearchComponent.h>

@protocol BaiduLocationManagerDelegate <NSObject>

@optional

/**
    开始定位
 */
- (void)startPositioning;
/**
 *  定位成功
 */
- (void)positioningSuccess:(BMKUserLocation *)location;

/**
 *  定位失败
 */
- (void)positioningError:(NSError *)error;

/**
 *  地理位置信息
 */
- (void)geographicInformation:(BMKReverseGeoCodeResult *)content;

@end

@interface BaiduLocationManager : NSObject<BMKLocationServiceDelegate,BMKGeoCodeSearchDelegate>

@property (strong, nonatomic) BMKLocationService *service;
@property (nonatomic,strong) BMKGeoCodeSearch *geographicSearch;
@property (nonatomic,weak) id<BaiduLocationManagerDelegate>locationDelegate;


/**
 *  用户单例
 */
+ (instancetype)manager;

/**
 *  开始定位
 */
- (void)startPositioning;

/**
 *  停止定位
 */
- (void)stopPositioning;



@end
