//
//  NetWorkRequestManager.m
//  Patrol
//
//  Created by 曹云霄 on 2017/7/19.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import "NetWorkRequestManager.h"

@implementation NetWorkRequestManager


+ (instancetype)shareManager
{
    static NetWorkRequestManager *shareManager = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        shareManager = [[NetWorkRequestManager alloc] init];
    });
    return shareManager;
}

- (AFHTTPSessionManager *)manager
{
    if (!_manager) {
        _manager = [AFHTTPSessionManager manager];
        _manager.requestSerializer = [AFJSONRequestSerializer serializer];
        _manager.responseSerializer = [AFJSONResponseSerializer serializer];
        // 设置请求头
        [_manager.requestSerializer setValue:@"application/json;charset=utf-8"
                          forHTTPHeaderField:@"Content-Type"];
        [_manager.requestSerializer setValue:[[[NSBundle mainBundle] infoDictionary]
                                              objectForKey:@"CFBundleShortVersionString"] forHTTPHeaderField:@"Version"];
        [_manager.requestSerializer setValue:[[UIDevice currentDevice] systemVersion] forHTTPHeaderField:@"DeviceVersion"];
        [_manager.requestSerializer setValue:[UIDevice deviceModelName] forHTTPHeaderField:@"Device"];
        _manager.requestSerializer.timeoutInterval = 30.0f;
    }
    //企业验证码
    ICRUserUtil *user = [ICRUserUtil sharedInstance];
    if (user.f_enterprise_uuid) {
        [_manager.requestSerializer setValue:user.f_enterprise_uuid
                          forHTTPHeaderField:@"enterprise"];
    }
    return _manager;
}


/**
 POST请求
 
 @param URLString 请求路径
 @param parmeter  参数
 @param success   成功回调
 @param failure   失败回调
 */
- (void)POST:(NSString *)URLString withParmeter:(NSDictionary *)parmeter
     success:(SuccessBlock)success
     failure:(ErrorBlock)failure
{
    [self.manager POST:URLString parameters:parmeter success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
        if (success) {
            success(responseObject);
        }
        NSLog(@"地址：%@",URLString);
        NSLog(@"参数：%@",[parmeter JSONString]);
        NSLog(@"success: %@",[responseObject toJSONString]);
        
    } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
        if (failure) {
            failure(error.localizedDescription);
        }
        NSLog(@"地址：%@",URLString);
        NSLog(@"参数：%@",[parmeter JSONString]);
        NSLog(@"错误：%@",error);
    }];
}



/**
 GET请求
 
 @param URLString 请求路径
 @param parmeter  参数
 @param success   成功回调
 @param failure   失败回调
 */
- (void)GET:(NSString *)URLString withParmeter:(NSDictionary *)parmeter
    success:(SuccessBlock)success
    failure:(ErrorBlock)failure
{
    [self.manager GET:URLString parameters:parmeter success:^(NSURLSessionDataTask * _Nonnull task, id  _Nullable responseObject) {
        if (success) {
            success(responseObject);
        }
        NSLog(@"地址：%@",URLString);
        NSLog(@"参数：%@",parmeter);
        NSLog(@"success: %@",[responseObject toJSONString]);

    } failure:^(NSURLSessionDataTask * _Nullable task, NSError * _Nonnull error) {
        if (failure) {
            failure(error.localizedDescription);
        }
        NSLog(@"地址：%@",URLString);
        NSLog(@"参数：%@",parmeter);
        NSLog(@"错误：%@",error);
    }];
}








@end
