//
//  PicViewModel.m
//  RealEstateManagement
//
//  Created by Javen on 2017/1/6.
//  Copyright © 2017年 上海勾芒信息科技. All rights reserved.
//

#import "PicViewModel.h"

@implementation PicViewModel

- (instancetype)init {
    self = [super init];
    if (self) {
        self.maxPictureNumber = 4;
        self.columns = 2;
    }
    return self;
}
/**
 获取cell的高度
 
 @return 高度
 */
- (CGFloat)cellHeight {
    NSInteger rowNumbers = [self pictureRowNumbers];
    return rowNumbers * (kPicCellSize.height + 20);
}


/**
 获取图片行数
 
 @return 行数
 */
- (NSInteger)pictureRowNumbers {
    NSInteger picCount = self.arrPics.count;
    //如果非只读的情况，则还需要多计算一个添加按钮的位置
    if (self.type == kPicCellTypeAdd) {
        if (self.arrPics.count != self.maxPictureNumber) {
            picCount += 1;
        }
    }
    
    //行数
    NSInteger div = picCount / self.columns;
    NSInteger remainder = picCount % self.columns;
    if (remainder != 0) {
        div = div + 1;
    }
    return div;
}

- (NSMutableArray *)arrPics {
    if (!_arrPics) {
        _arrPics = [NSMutableArray array];
    }
    return _arrPics;
}

@end
