//
//  UIView+FindUIViewController.m
//  JobTalk
//
//  Created by Xummer on 1/20/15.
//  Copyright (c) 2015 BST. All rights reserved.
//

#import "UIView+FindUIViewController.h"

@implementation UIView (FindUIViewController)

- (UIViewController *)firstAvailableUIViewController {
    // convenience function for casting and to "mask" the recursive function
    return (UIViewController *)[self traverseResponderChainForUIViewController];
}

- (id)traverseResponderChainForUIViewController {
    id nextResponder = [self nextResponder];
    if ([nextResponder isKindOfClass:[UIViewController class]]) {
        return nextResponder;
    }
    else if ([nextResponder isKindOfClass:[UIView class]]) {
        return [nextResponder traverseResponderChainForUIViewController];
    }
    else {
        return nil;
    }
}

@end

@implementation UIView (Extend)

- (NSArray *)subviewsWithClass:(Class)aClass {
    NSMutableArray *arrTmp = [NSMutableArray array];
    for (UIView *view in self.subviews) {
        if ([view isKindOfClass:aClass]) {
            [arrTmp addObject:view];
        }
    }
    
    return [arrTmp count] > 0 ? arrTmp : nil;
}

- (id)viewWithClass:(Class)aClass {
    
    __block id machedView = nil;
    [self.subviews enumerateObjectsUsingBlock:^(id obj, NSUInteger idx, BOOL *stop) {
        if ([obj isKindOfClass:aClass]) {
            machedView = obj;
            *stop = YES;
        }
    }];
    return machedView;
}

- (void)removeSubViewWithClass:(Class)aClass {
    [[self viewWithClass:aClass] removeFromSuperview];
}

- (void)removeSubViewWithTag:(NSInteger)tag {
    [[self viewWithTag:tag] removeFromSuperview];
}

- (void)removeAllSubViews {
    [self.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
}

- (void)autoresizingWithStrechFullSize {
    self.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
}

- (void)autoresizingWithVerticalCenter {
    self.autoresizingMask = UIViewAutoresizingFlexibleTopMargin | UIViewAutoresizingFlexibleBottomMargin;
}

- (void)autoresizingWithHorizontalCenter {
    self.autoresizingMask = UIViewAutoresizingFlexibleLeftMargin | UIViewAutoresizingFlexibleRightMargin;
}

@end
