//
//  UIViewController+StoryBoard.h
//  Patrol
//
//  Created by 曹云霄 on 2017/7/20.
//  Copyright © 2017年 上海勾芒科技信息有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>



/**
 StoryBoard类型

    - STORYBOARD_TYPE_MAIN:                登录
    - STORYBOARD_TYPE_HOME:                首页
    - STORYBOARD_TYPE_BUSINESS:            业务
    - STORYBOARD_TYPE_REPORT:              公告
    - STORYBOARD_TYPE_ME:                  我的
    - STORYBOARD_TYPE_PATROLINSPECTRESULT: VI检查结果查看
    - STORYBOARD_TYPE_MESSAGE:             消息
    - STORYBOARD_TYPE_LEARN:               学习
    - STORYBOARD_TYPE_FILTER:              筛选
    - STORYBOARD_TYPE_PATROLINSPECT:       VI检查任务
    - STORYBOARD_TYPE_RECTIFICATION:       整改
    - STORYBOARD_TYPE_INSPECTRESULT:       自检结果
    - STORYBOARD_TYPE_EQUIPMENTREPAIRS:    设备报修
    - STORYBOARD_TYPE_STORE:               门店模块
 */
typedef NS_ENUM(NSInteger, STORYBOARD_TYPE_) {
    STORYBOARD_TYPE_MAIN,
    STORYBOARD_TYPE_HOME,
    STORYBOARD_TYPE_BUSINESS,
    STORYBOARD_TYPE_REPORT,
    STORYBOARD_TYPE_ME,
    STORYBOARD_TYPE_PATROLINSPECTRESULT,
    STORYBOARD_TYPE_MESSAGE,
    STORYBOARD_TYPE_LEARN,
    STORYBOARD_TYPE_FILTER,
    STORYBOARD_TYPE_PATROLINSPECT,
    STORYBOARD_TYPE_RECTIFICATION,
    STORYBOARD_TYPE_INSPECTRESULT,
    STORYBOARD_TYPE_EQUIPMENTREPAIRS,
    STORYBOARD_TYPE_STORE
};




@interface UIViewController (StoryBoard)




+ (instancetype)viewControllerWithStoryBoardType:(STORYBOARD_TYPE_)type;

@end
