//
//  IBTImagePicker.h
//  Cruiser
//
//  Created by Xummer on 4/17/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"
#import <MobileCoreServices/MobileCoreServices.h>

typedef NS_OPTIONS(NSUInteger, IBTMediaBrowserType) {
    kIBTMediaBImage = 1 << 0,
    kIBTMediaBVideo = 1 << 1,
    kIBTMediaBAll   = kIBTMediaBImage | kIBTMediaBVideo,
};

// ====== IBTImagePickerController ======
@interface IBTImagePickerController : UIImagePickerController

@end

// ====== IBTImagePickerDelegate ======

@protocol IBTImagePickerDelegate <NSObject>
@optional
- (void)imagePicker:(IBTImagePickerController *)picker didImagePicked:(UIImage *)image referenceURL:(NSURL *)imageUrl;
- (void)imagePicker:(IBTImagePickerController *)picker didVideoPickedWithURL:(NSURL *)videoUrl;
@end

@interface IBTImagePicker : IBTObject

@property (weak, nonatomic) id <IBTImagePickerDelegate> m_delegate;

// Class Method
+ (NSString *)uniqueName;
+ (NSString *)handleImageName:(NSString *)imageName;
+ (NSString *)handleVideoName:(NSString *)videoName;

+ (UIImage *)getVideoMainFrameWithUrl:(NSURL *)url;

+ (BOOL)startCameraControllerFromViewController:(UIViewController*)controller
                                      mediaType:(IBTMediaBrowserType)type
                                       editable:(BOOL)eFlag
                                  usingDelegate:(id <UIImagePickerControllerDelegate,
                                                 UINavigationControllerDelegate>)delegate;

+ (BOOL)startMediaBrowserFromViewController:(UIViewController*)controller
                                  mediaType:(IBTMediaBrowserType)type
                                   editable:(BOOL)eFlag
                              usingDelegate:(id <UIImagePickerControllerDelegate,
                                             UINavigationControllerDelegate>)delegate;

+ (void)showImagePickerTitle:(NSString *)title
                   mediaType:(IBTMediaBrowserType)type
                    editable:(BOOL)eFlag
          fromViewController:(UIViewController*)controller
               usingDelegate:(id <UIImagePickerControllerDelegate,
                              UINavigationControllerDelegate>)delegate;

+ (void)showImagePickerTitle:(NSString *)title
                albumBtnName:(NSString *)albumName
               cameraBtnName:(NSString *)cameraName
               cancelBtnName:(NSString *)cancelName
                   mediaType:(IBTMediaBrowserType)type
                    editable:(BOOL)eFlag
          fromViewController:(UIViewController*)controller
               usingDelegate:(id <UIImagePickerControllerDelegate,
                              UINavigationControllerDelegate>)delegate;

// Instance Method

- (BOOL)startCameraControllerFromViewController:(UIViewController *)controller
                                      mediaType:(IBTMediaBrowserType)type
                                       editable:(BOOL)eFlag;

- (BOOL)startMediaBrowserFromViewController:(UIViewController *)controller
                                  mediaType:(IBTMediaBrowserType)type
                                   editable:(BOOL)eFlag;

- (void)showImagePickerTitle:(NSString *)title
                   mediaType:(IBTMediaBrowserType)type
                    editable:(BOOL)eFlag
          fromViewController:(UIViewController *)controller;

- (void)showImagePickerTitle:(NSString *)title
                albumBtnName:(NSString *)albumName
               cameraBtnName:(NSString *)cameraName
               cancelBtnName:(NSString *)cancelName
                   mediaType:(IBTMediaBrowserType)type
                    editable:(BOOL)eFlag
          fromViewController:(UIViewController *)controller;

@end

