//
//  ICRHTTPController.h
//  Cruiser
//
//  Created by Xummer on 3/26/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"
#import "ICRAnnouncement.h"

typedef NS_ENUM(NSUInteger, ICRAttachmentType) {
    kAttachmentBoard = 0,
    kAttachmentAnswer,
    kAttachmentTask,
    
    // Insert enum here
    kAttachmentTypeCount,
};


@interface ICRHTTPController : IBTObject

+ (instancetype)sharedController;

// Restful API

// User
/* 用户登录验证（读）*/
- (void)doLoginWithUserName:(NSString *)userName
                   password:(NSString *)password
               registerCode:(NSString *)registerCode
                    success:(void (^)(id data))succ
                    failure:(void (^)(id data))fail;

/* 密码修改（写）*/
- (void)doChangePassword:(NSString *)nsPassword
             newPassword:(NSString *)nsNewPassword
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;


//1.3	下载用户信息
- (void)getUserWithStartTime:(NSString *)start_time
                  pageNumber:(NSUInteger)page_number
                    pageSize:(NSUInteger)page_size
                     success:(void (^)(id data))succ
                     failure:(void (^)(id data))fail;
//1.4   下载 门店
- (void)getStoreWithStartTime:(NSString *)start_time
                   pageNumber:(NSUInteger)page_number
                     pageSize:(NSUInteger)page_size
                      success:(void (^)(id data))succ
                      failure:(void (^)(id data))fail;
//2.1 下载VI检查模板
- (void)getPatrolTemplateWithPurpose: ( NSString *)purpose
                           //startTime:(NSString *)start_tim
                      pageNumber:(NSUInteger)page_number
                        pageSize:(NSUInteger)page_size
                         success:(void (^)(id data))succ
                         failure:(void (^)(id data))fail;
//3.1 下载VI检查任务
- (void)getMyPatrolWithCategory: (NSString *)category
                      startTime:(NSString *)start_time
                       dateType:(NSString *)date_type
                           pageNumber:(NSUInteger)page_number
                             pageSize:(NSUInteger)page_size
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

//3.2 提交VI检查结果
- (void)doSubmitAnswerPatrolPlanWithID:(NSString *)planID
                              infoData:(id)data
                               success:(void (^)(id data))succ
                               failure:(void (^)(id data))fail;
//3.3下载门店结果
- (void)doGetStoreResultWithPlanID:(NSString *)planID
                           storeID:(NSString *)storeID
                           success:(void (^)(id data))succ
                           failure:(void (^)(id data))fail;



//4.1获取报修单列表（读）
- (void)getRepairListWithData:(id)data
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;
//4.2 报修单明细（读）
- (void)getRepairItemsWithRepairUuid:(NSString *)repairUuid
                                     success:(void (^)(id))succ
                                     failure:(void (^)(id))fail;
//4.3 申请结束报修单（写））
- (void)dorepairApplicationWithRepairUuid:(NSString *)repairUuid
                             version: (NSInteger)version
                             success:(void (^)(id))succ
                             failure:(void (^)(id))fail;
//4.4 结束报修单（写））
- (void)dorepairFinishWithRepairUuid:(NSString *)repairUuid
                             version: (NSInteger)version
                        attachmentId: (NSString *)attachmentId
                             success:(void (^)(id))succ
                             failure:(void (^)(id))fail;
//5.1 保存许可证（写）
- (void)doSaveLicenceResultWithData:(id)data
                               success:(void (^)(id))succ
                               failure:(void (^)(id))fail;
//5.2 提交许可证（写）
- (void)doSubmitLicenceResultWithData:(id)data
                                 success:(void (^)(id))succ
                                 failure:(void (^)(id))fail;
//5.3 获取许可证列表（读）
- (void)getLicenceListWithData:(id)data
                      success:(void (^)(id))succ
                      failure:(void (^)(id))fail;
//5.4 许可证明细（读）
- (void)getLicenceItemsWithLicenceUuid:(NSString *)licenceUuid
                                 success:(void (^)(id))succ
                                 failure:(void (^)(id))fail;
//5.5删除许可证（写）
- (void)doLicenceRemoveWithLicenceUuid:(NSString *)licenceUuid
                                version: (NSInteger)version
                                success:(void (^)(id))succ
                                failure:(void (^)(id))fail;
//5.6审批拒绝许可证（写）
- (void)doLicenceRejectWithLicenceUuid:(NSString *)licenceUuid
                                     version: (NSInteger)version
                               rejectCausen: (NSString *)cause
                                     success:(void (^)(id))succ
                                     failure:(void (^)(id))fail;
//5.7 审批通过许可证（写）
- (void)doLicenceApproveWithLicenceUuid:(NSString *)licenceUuid
                               version: (NSInteger)version
                               success:(void (^)(id))succ
                               failure:(void (^)(id))fail;

// 申请审批许可证（写）
- (void)doLicenceAskForApproveWithLicenceUuid:(NSString *)licenceUuid
                                      version: (NSInteger)version
                                      success:(void (^)(id))succ
                                      failure:(void (^)(id))fail;
// 关闭许可证
- (void)doLicenceAskForCloseWithLicenceUuid:(NSString *)licenceUuid
                                    version: (NSInteger)version
                                    success:(void (^)(id))succ
                                    failure:(void (^)(id))fail;
//5.8许可证操作日志列表（读）
- (void)getLicenceGet_logsWithLicenceUuid:(NSString *)licenceUuid
                               success:(void (^)(id))succ
                               failure:(void (^)(id))fail;
//6.1 保存拓站（写）
- (void)doSavePioneeringResultWithData:(id)data
                                 success:(void (^)(id))succ
                                 failure:(void (^)(id))fail;
//6.2提交拓站（写）
- (void)doSubmitPioneeringResultWithData:(id)data
                                 success:(void (^)(id))succ
                                 failure:(void (^)(id))fail;
//6.3 获取拓站列表（读）
- (void)getPioneeringListWithData:(id)data
                        success:(void (^)(id))succ
                          failure:(void (^)(id))fail;

//6.4 拓站明细（读）
- (void)getPioneeringItemsWithPioneeringUuid:(NSString *)pioneeringUuid
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;
//6.5 删除拓站（写）
- (void)doPioneeringRemoveWithPioneeringUuid:(NSString *)pioneeringUuid
                                     version: (NSInteger)version
                                     success:(void (^)(id))succ
                                     failure:(void (^)(id))fail;


// 上传附件
- (void)doAttachmentUploadWithData:(id)data
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;

//- (void)doAttachmentUploadByFile:(NSString*)entity_uuid type:(NSString*)entity_type dicArray: (id)data
//                         success:(void (^)(id))succ
//                         failure:(void (^)(id))fail;

///7.6 取得附件列表路径
- (void)getAttachmentUrlsWithEntityType:(NSString *)entityType
                          andEntityUuid:(NSString *)entityUuid
                                success:(void (^)(id))succ
                                failure:(void (^)(id))fail;

//// 上传多个附件：
- (void)multiPartUploadWithEntityType:(NSString *)entityType
                           entityUuid:(NSString *)entityUuid
                 arrayPostAttachments: (NSArray *)array
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;

//// 上传多个附件： 带有删除的图片
- (void)multiPartUploadWithEntityType:(NSString *)entityType
                           entityUuid:(NSString *)entityUuid
                          deleteUuids: (NSString *)delUuids
                 arrayPostAttachments: (NSArray *)array
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;
//删除附件
- (void)deleteAttachments: (NSString *)delStr
                  success:(void (^)(id))succ
                  failure:(void (^)(id))fail;
//公告管理

//	下载附件，直接下载方式
+ (NSString *)AttachmentUrlWithID:(id)attachmentID;
// Board
/* 公告列表（读）
 获得公告列表
 */
- (void)doGetBoardListWithType:(ICRAnnouncementReadType)eType
                    pageNumber:(NSUInteger)page_number
                      pageSize:(NSUInteger)page_size
                       success:(void (^)(id data))succ
                       failure:(void (^)(id data))fail;
/* 读取公告（读）
 读取单个公告
 */
- (void)doGetBoardWithID:(NSString *)boardID
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;

/* 提交公告已读状态（写）*/
- (void)doReadBoardWithID:(NSString *)boardID
                  success:(void (^)(id data))succ
                  failure:(void (^)(id data))fail;

//版本更新
- (void)getVeisionIdWithType:(NSString *)type
                     success:(void (^)(id))succ
                     failure:(void (^)(id))fail;

//8.1 获取当前位置附近的油站(读)
- (void)getNearStoreWithLongitude:(NSString *)longitude
                      andLatitude: (NSString *)latitude
                     success:(void (^)(id))succ
                     failure:(void (^)(id))fail;
//9.1	签到
- (void)getSignInIdWithDictionary:(NSDictionary *)dict
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;

//	天气
- (void)getWeatherInfoWithCityName:(NSString *)cityName
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;
@end


